/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.jenax.arq.util.tuple.TupleOps;
import org.aksw.jenax.arq.util.tuple.query.TupleQuery;
import org.aksw.jenax.arq.util.tuple.query.TupleQueryImpl;
import org.aksw.jenax.arq.util.tuple.query.TupleQuerySupport;
import org.aksw.jenax.arq.util.tuple.resultset.ResultStreamer;
import org.aksw.jenax.arq.util.tuple.resultset.ResultStreamerFromTuple;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;

public interface TupleTableCore<T, X>
extends TupleQuerySupport<T, X> {
    public void clear();

    public void add(T var1);

    public void delete(T var1);

    public boolean contains(T var1);

    default public Stream<T> findTuples(List<X> pattern) {
        return this.findTuples(pattern, List::get);
    }

    public <D> Stream<T> findTuples(D var1, TupleAccessor<? super D, ? extends X> var2);

    public Stream<T> findTuples();

    @Override
    default public ResultStreamer<T, X, Tuple<X>> find(TupleQuery<X> tupleQuery) {
        List<X> pattern = tupleQuery.getPattern();
        int[] project = tupleQuery.getProject();
        Function<T, Tuple<X>> projector = TupleOps.createProjector(project, this.getTupleAccessor());
        Supplier tupleStreamSupplier = () -> {
            Stream<Object> domainStream = this.findTuples(pattern);
            Stream<Tuple> tupleStream = domainStream.map(projector::apply);
            if (tupleQuery.isDistinct()) {
                tupleStream = tupleStream.distinct();
            }
            return tupleStream;
        };
        return new ResultStreamerFromTuple(this.getDimension(), tupleStreamSupplier, this.getTupleAccessor());
    }

    default public long size() {
        return this.find(new TupleQueryImpl(this.getDimension())).streamAsTuple().count();
    }

    default public int getDimension() {
        return this.getTupleAccessor().getDimension();
    }

    public TupleBridge<T, X> getTupleAccessor();

    public static Node nullToAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    public static Node anyToNull(Node n) {
        return Node.ANY.equals((Object)n) ? null : n;
    }
}

