/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.util.range.LongRanges;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.query.OpVisitorTriplesQuads;
import org.aksw.jenax.arq.util.query.TransformCollectOps;
import org.aksw.jenax.arq.util.syntax.ElementTransformSubst2;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.util.backport.syntaxtransform.QueryTransformOps;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.SortCondition;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryShallowCopyWithPresetPrefixes;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.PrefixMapping2;

public class QueryUtils {
    public static Query setQueryType(Query query, QueryType queryType) {
        switch (queryType) {
            case ASK: {
                query.setQueryAskType();
                break;
            }
            case CONSTRUCT: {
                query.setQueryConstructType();
                break;
            }
            case DESCRIBE: {
                query.setQueryDescribeType();
                break;
            }
            case CONSTRUCT_JSON: {
                query.setQueryJsonType();
                break;
            }
            case SELECT: {
                query.setQuerySelectType();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown query type: " + String.valueOf(queryType));
            }
        }
        return query;
    }

    public static Query applyElementTransform(Query beforeQuery, Function<? super Element, ? extends Element> transform) {
        Query result = beforeQuery.cloneQuery();
        Element beforePattern = result.getQueryPattern();
        if (beforePattern != null) {
            Element afterPattern = transform.apply((Element)beforePattern);
            result.setQueryPattern(afterPattern);
        }
        return result;
    }

    public static Query applyOpTransform(Query beforeQuery, Function<? super Op, ? extends Op> transform) {
        Op beforeOp = Algebra.compile((Query)beforeQuery);
        Op afterOpTmp = transform.apply((Op)beforeOp);
        Collection mentionedVars = OpVars.mentionedVars((Op)beforeOp);
        final VarGeneratorBlacklist vargen = VarGeneratorBlacklist.create(mentionedVars);
        TransformCopy nodeFix = new TransformCopy(false){
            protected Map<Node, Var> map;
            {
                super(arg0);
                this.map = new HashMap<Node, Var>();
            }

            public Op transform(OpGraph opGraph, Op subOp) {
                Var v;
                Node gn = opGraph.getNode();
                if (gn.isBlank() || gn.isVariable() && gn.getName().startsWith("?")) {
                    v = this.map.get(gn);
                    if (v == null) {
                        v = (Var)vargen.next();
                        this.map.put(gn, v);
                    }
                } else {
                    return super.transform(opGraph, subOp);
                }
                OpGraph result = new OpGraph((Node)v, subOp);
                return result;
            }
        };
        Op afterOp = Transformer.transform((Transform)nodeFix, (Op)afterOpTmp);
        Query afterQueryTmp = OpAsQuery.asQuery((Op)afterOp);
        Query result = QueryUtils.restoreQueryForm(afterQueryTmp, beforeQuery);
        return result;
    }

    public static Query restoreQueryForm(Query query, Query proto) {
        Query result;
        if (!query.isSelectType()) {
            throw new RuntimeException("SELECT query expected - got: " + String.valueOf(query));
        }
        QueryType tgtQueryType = proto.queryType();
        switch (tgtQueryType) {
            case SELECT: {
                result = query.cloneQuery();
                LinkedHashSet expectedVars = new LinkedHashSet(proto.getProjectVars());
                VarExprList replacement = new VarExprList();
                LinkedHashSet actualVars = new LinkedHashSet(result.getProjectVars());
                Sets.SetView missingVars = Sets.difference(expectedVars, actualVars);
                Sets.SetView exceedingVars = Sets.difference(actualVars, expectedVars);
                if (!missingVars.isEmpty()) {
                    throw new RuntimeException("Missing vars: " + String.valueOf(missingVars) + ", expected: " + String.valueOf(expectedVars) + ", actual: " + String.valueOf(actualVars));
                }
                if (exceedingVars.isEmpty()) break;
                VarExprList actual = result.getProject();
                for (Var expectedVar : expectedVars) {
                    Expr expr = actual.getExpr(expectedVar);
                    VarExprListUtils.add(replacement, expectedVar, expr);
                }
                VarExprListUtils.replace(result.getProject(), replacement);
                result.setQueryResultStar(false);
                result.setResultVars();
                break;
            }
            case CONSTRUCT: {
                result = QueryUtils.selectToConstruct(query, proto.getConstructTemplate());
                break;
            }
            case ASK: {
                result = query.cloneQuery();
                result.setQueryAskType();
                break;
            }
            case DESCRIBE: {
                result = query.cloneQuery();
                result.setQueryDescribeType();
                for (Node node : proto.getResultURIs()) {
                    result.addDescribeNode(node);
                }
                for (Var var : proto.getProjectVars()) {
                    result.addDescribeNode((Node)var);
                }
                break;
            }
            case CONSTRUCT_JSON: {
                result = query.cloneQuery();
                result.setQueryJsonType();
                proto.getJsonMapping().entrySet().forEach(e -> result.addJsonMapping((String)e.getKey(), (Node)e.getValue()));
                break;
            }
            default: {
                throw new RuntimeException("unsupported query type");
            }
        }
        result.setSyntax(proto.getSyntax());
        result.setPrefixMapping(proto.getPrefixMapping());
        result.getGraphURIs().addAll(proto.getGraphURIs());
        result.getNamedGraphURIs().addAll(proto.getNamedGraphURIs());
        return result;
    }

    public static Query unionConstruct(Query ... queries) {
        return QueryUtils.unionConstruct(Arrays.asList(queries));
    }

    public static Query unionConstruct(Iterable<Query> queries) {
        Query result = new Query();
        LinkedHashSet quadPatterns = new LinkedHashSet();
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (Query query : queries) {
            result.getPrefixMapping().setNsPrefixes(query.getPrefixMapping());
            Template tmp = query.getConstructTemplate();
            quadPatterns.addAll(tmp.getQuads());
            elements.add(query.getQueryPattern());
        }
        result.setQueryConstructType();
        result.setConstructTemplate(new Template(new QuadAcc(new ArrayList(quadPatterns))));
        result.setQueryPattern(ElementUtils.unionIfNeeded(elements));
        return result;
    }

    public static Query constructToSelect(Query query) {
        Preconditions.checkArgument((boolean)query.isConstructType(), (Object)"Not a construct query.");
        Template template = query.getConstructTemplate();
        Set<Var> vars = QuadPatternUtils.getVarsMentioned(template.getQuads());
        Query result = org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps.shallowCopy((Query)query);
        result.setQuerySelectType();
        if (vars.isEmpty()) {
            result.setQueryResultStar(true);
        } else {
            result.setQueryResultStar(false);
            result.getProject().clear();
            result.addProjectVars(vars);
        }
        return result;
    }

    public static Query selectToConstruct(Query query, Template template) {
        Query result = new Query();
        result.setQueryConstructType();
        result.setConstructTemplate(template != null ? template : new Template(new BasicPattern()));
        boolean canActAsConstruct = QueryUtils.canActAsConstruct(query);
        if (canActAsConstruct) {
            result.setQueryPattern(query.getQueryPattern());
        } else {
            result.setQueryPattern((Element)new ElementSubQuery(query));
        }
        result.setLimit(query.getLimit());
        result.setOffset(query.getOffset());
        List scs = query.getOrderBy();
        if (scs != null) {
            for (SortCondition sc : scs) {
                result.addOrderBy(sc);
            }
            scs.clear();
        }
        query.setLimit(Long.MIN_VALUE);
        query.setOffset(Long.MIN_VALUE);
        return result;
    }

    public static Query rewrite(Query beforeQuery, Function<? super Op, ? extends Op> xform) {
        Op beforeOp = Algebra.compile((Query)beforeQuery);
        Op afterOp = xform.apply((Op)beforeOp);
        Query afterQuery = OpAsQuery.asQuery((Op)afterOp);
        Query result = QueryUtils.restoreQueryForm(afterQuery, beforeQuery);
        return result;
    }

    public static Element asPatternForConstruct(Query q) {
        Element result = QueryUtils.canActAsConstruct(q) ? q.getQueryPattern() : new ElementSubQuery(q);
        return result;
    }

    public static boolean canActAsConstruct(Query q) {
        boolean result = true;
        result = result && !q.hasAggregators();
        result = result && !q.hasGroupBy();
        result = result && !q.hasValues();
        result = !q.hasHaving();
        result = result && !VarExprListUtils.hasExprs(q.getProject());
        return result;
    }

    public static Set<Var> mentionedVars(Query query) {
        Set<Node> nodes = QueryUtils.mentionedNodes(query);
        Set<Var> result = NodeUtils.getVarsMentioned(nodes);
        return result;
    }

    public static Set<Node> mentionedNodes(Query query) {
        NodeTransformCollectNodes xform = new NodeTransformCollectNodes();
        QueryUtils.applyNodeTransform(query, (NodeTransform)xform);
        Set<Node> result = xform.getNodes();
        return result;
    }

    public static Var freshVar(Query query) {
        Var result = QueryUtils.freshVar(query, null);
        return result;
    }

    public static Var freshVar(Query query, String baseVarName) {
        baseVarName = baseVarName == null ? "c" : baseVarName;
        Set<Var> varsMentioned = QueryUtils.mentionedVars(query);
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create(baseVarName, varsMentioned);
        Var result = (Var)varGen.next();
        return result;
    }

    public static Map<String, Node> applyNodeTransform(Map<String, Node> jsonMapping, NodeTransform nodeTransform) {
        Map<String, Node> result = jsonMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Node)nodeTransform.apply((Object)((Node)e.getValue()))));
        return result;
    }

    public static Query applyNodeTransform(Query query, NodeTransform nodeTransform) {
        Query result;
        Element resultEl;
        Map before;
        ElementTransformSubst2 eltrans = new ElementTransformSubst2(nodeTransform);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, (ElementTransform)eltrans);
        Template template = null;
        if (query.isConstructType()) {
            Template tmp = query.getConstructTemplate();
            if (tmp.containsRealQuad()) {
                before = QuadPatternUtils.create(tmp.getQuads());
                after = NodeTransformLib.transform((NodeTransform)nodeTransform, (QuadPattern)before);
                template = new Template(new QuadAcc(after.getList()));
            } else {
                before = tmp.getBGP();
                after = NodeTransformLib.transform((NodeTransform)nodeTransform, (BasicPattern)before);
                template = new Template(after);
            }
        }
        Map<String, Node> jsonMapping = null;
        if (query.isJsonType()) {
            before = query.getJsonMapping();
            jsonMapping = QueryUtils.applyNodeTransform(before, nodeTransform);
        }
        if ((resultEl = (result = QueryTransformOps.transform(query, (ElementTransform)eltrans, (ExprTransform)exprTrans)).getQueryPattern()) != null) {
            ElementWalker.walk((Element)resultEl, (ElementVisitor)new ElementVisitorBase(){

                public void visit(ElementSubQuery el) {
                    el.getQuery().getPrefixMapping().clearNsPrefixMap();
                }
            });
        }
        if (template != null) {
            result.setQueryConstructType();
            result.setConstructTemplate(template);
        }
        if (jsonMapping != null) {
            result.setQueryJsonType();
            jsonMapping.entrySet().forEach(e -> result.addJsonMapping((String)e.getKey(), (Node)e.getValue()));
        }
        return result;
    }

    public static PrefixMapping usedPrefixes(Query query, PrefixMapping global) {
        PrefixMapping local = query.getPrefixMapping();
        PrefixMapping pm = global == null ? local : new PrefixMapping2(global, local);
        PrefixMapping result = QueryUtils.usedReferencePrefixes(query, pm);
        return result;
    }

    public static PrefixMapping usedPrefixes(Query query) {
        PrefixMapping result = QueryUtils.usedPrefixes(query, null);
        return result;
    }

    public static PrefixMapping usedReferencePrefixes(Query query, PrefixMapping pm) {
        NodeTransformCollectNodes nodeUsageCollector = new NodeTransformCollectNodes();
        Query shallowCopy = QueryShallowCopyWithPresetPrefixes.shallowCopy(query, null);
        QueryUtils.applyNodeTransform(shallowCopy, (NodeTransform)nodeUsageCollector);
        Set<Node> nodes = nodeUsageCollector.getNodes();
        PrefixMapping result = PrefixUtils.usedPrefixes(pm, nodes);
        return result;
    }

    public static Query optimizePrefixes(Query query, PrefixMapping globalPm) {
        PrefixMapping usedPrefixes = QueryUtils.usedPrefixes(query, globalPm);
        query.setPrefixMapping(usedPrefixes);
        return query;
    }

    public static Query optimizePrefixes(Query query) {
        QueryUtils.optimizePrefixes(query, null);
        return query;
    }

    public static Query randomizeVars(Query query) {
        Map<Var, Var> varMap = QueryUtils.createRandomVarMap(query, "rv");
        Query result = QueryTransformOps.transform(query, varMap);
        return result;
    }

    public static Map<Var, Var> createRandomVarMap(Query query, String base) {
        Collection vars = PatternVars.vars((Element)query.getQueryPattern());
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create(base, vars);
        Map<Var, Var> varMap = vars.stream().collect(Collectors.toMap(v -> v, v -> (Var)gen.next()));
        return varMap;
    }

    public static void injectFilter(Query query, String varName, Node node) {
        QueryUtils.injectFilter(query, Var.alloc((String)varName), node);
    }

    public static void injectFilter(Query query, Var var, Node node) {
        E_Equals expr = new E_Equals((Expr)new ExprVar(var), (Expr)NodeValue.makeNode((Node)node));
        QueryUtils.injectFilter(query, (Expr)expr);
    }

    public static void injectFilter(Query query, String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        QueryUtils.injectFilter(query, expr);
    }

    public static void injectFilter(Query query, Expr expr) {
        QueryUtils.injectElement(query, (Element)new ElementFilter(expr));
    }

    public static void injectElement(Query query, Element element) {
        Element queryPattern = query.getQueryPattern();
        Element replacement = ElementUtils.mergeElements(queryPattern, element);
        query.setQueryPattern(replacement);
    }

    public static Range<Long> toRange(OpSlice op) {
        Range<Long> result = QueryUtils.toRange(op.getStart(), op.getLength());
        return result;
    }

    public static Op applyRange(Op op, Range<Long> range) {
        long start = QueryUtils.rangeToOffset(range);
        long length = QueryUtils.rangeToLimit(range);
        OpSlice result = start == Long.MIN_VALUE && length == Long.MIN_VALUE ? op : new OpSlice(op, start, length);
        return result;
    }

    public static Query applySlice(Query query, Long offset, Long limit, boolean cloneOnChange) {
        Query result;
        Range<Long> child;
        Range<Long> parent = QueryUtils.toRange(query);
        Range<Long> subRange = QueryUtils.subRange(parent, child = QueryUtils.toRange(offset, limit));
        boolean isUnchanged = subRange.equals(parent);
        boolean hasChanged = !isUnchanged;
        Query query2 = result = cloneOnChange && hasChanged ? query.cloneQuery() : query;
        if (hasChanged) {
            QueryUtils.applyRange(result, subRange);
        }
        return result;
    }

    public static void applyRange(Query query, Range<Long> range) {
        long offset = QueryUtils.rangeToOffset(range);
        long limit = QueryUtils.rangeToLimit(range);
        query.setOffset(offset);
        query.setLimit(limit);
    }

    public static boolean hasNonZeroOffset(Long offset) {
        boolean result = false;
        if (offset != null) {
            long val = offset;
            result = val > 0L && val != Long.MIN_VALUE;
        }
        return result;
    }

    public static boolean hasLimit(Long limit) {
        boolean result = false;
        if (limit != null) {
            long val = limit;
            result = val != Long.MIN_VALUE && val != Long.MAX_VALUE;
        }
        return result;
    }

    public static long rangeToOffset(Range<Long> range) {
        Long tmp = LongRanges.rangeToOffset(range);
        long result = tmp == null || tmp == 0L ? Long.MIN_VALUE : tmp;
        return result;
    }

    public static long rangeToLimit(Range<Long> range) {
        Long tmp = LongRanges.rangeToLimit(range);
        long result = tmp == null ? Long.MIN_VALUE : tmp;
        return result;
    }

    public static Range<Long> toRange(Query query) {
        Range<Long> result = QueryUtils.toRange(query.getOffset(), query.getLimit());
        return result;
    }

    public static Range<Long> toRange(Long offset, Long limit) {
        Long min = offset == null || offset.equals(Long.MIN_VALUE) ? 0L : offset;
        Long delta = limit == null || limit.equals(Long.MIN_VALUE) ? null : limit;
        Long max = delta == null ? null : Long.valueOf(min + delta);
        Range result = max == null ? Range.atLeast((Comparable)min) : Range.closedOpen((Comparable)min, (Comparable)max);
        return result;
    }

    public static Range<Long> subRange(Range<Long> _parent, Range<Long> _child) {
        Range parent = _parent.canonical(DiscreteDomain.longs());
        Range child = _child.canonical(DiscreteDomain.longs());
        Range shiftedChild = RangeUtils.map((Range)child, e -> e + (Long)parent.lowerEndpoint());
        Range result = shiftedChild.intersection(parent);
        return result;
    }

    public static void applyDatasetDescription(Query query, DatasetDescription dd) {
        DatasetDescription present = query.getDatasetDescription();
        if (present == null && dd != null) {
            List items = dd.getDefaultGraphURIs();
            if (items != null) {
                for (String item : items) {
                    query.addGraphURI(item);
                }
            }
            if ((items = dd.getNamedGraphURIs()) != null) {
                for (String item : items) {
                    query.addNamedGraphURI(item);
                }
            }
        }
    }

    public static void overwriteDatasetDescription(Query query, DatasetDescription dd) {
        if (dd != null) {
            List queryGraphs;
            List items = dd.getDefaultGraphURIs();
            if (items != null && !items.isEmpty()) {
                queryGraphs = query.getGraphURIs();
                if (queryGraphs != null) {
                    queryGraphs.clear();
                }
                for (String item : items) {
                    query.addGraphURI(item);
                }
            }
            if ((items = dd.getNamedGraphURIs()) != null && !items.isEmpty()) {
                queryGraphs = query.getNamedGraphURIs();
                if (queryGraphs != null) {
                    queryGraphs.clear();
                }
                for (String item : items) {
                    query.addNamedGraphURI(item);
                }
            }
        }
    }

    public static Query fixVarNames(Query query) {
        Query result = query.cloneQuery();
        Element element = query.getQueryPattern();
        Element repl = ElementUtils.fixVarNames(element);
        result.setQueryPattern(repl);
        return result;
    }

    public static Query elementToQuery(Element pattern, String resultVar) {
        if (pattern == null) {
            return null;
        }
        Query query = new Query();
        Element cleanElement = pattern instanceof ElementGroup || pattern instanceof ElementSubQuery ? pattern : ElementUtils.createElementGroup(pattern);
        query.setQueryPattern(cleanElement);
        query.setQuerySelectType();
        if (resultVar == null) {
            query.setQueryResultStar(true);
        }
        query.setResultVars();
        if (resultVar != null) {
            query.getResultVars().add(resultVar);
        }
        return query;
    }

    public static Query elementToQuery(Element pattern) {
        return QueryUtils.elementToQuery(pattern, null);
    }

    public static Set<Quad> instanciate(Iterable<Quad> quads, Binding binding) {
        HashSet<Quad> result = new HashSet<Quad>();
        Node[] nodes = new Node[4];
        for (Quad quad : quads) {
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode(quad, i);
                if (node.isVariable()) {
                    node = binding.get((Var)node);
                }
                if (node == null || i < 3 && node.isLiteral()) {
                    result.clear();
                    return result;
                }
                nodes[i] = node;
            }
            Quad inst = QuadUtils.create(nodes);
            result.add(inst);
        }
        return result;
    }

    public static Var extractSoleProjectVar(Query query) {
        List vars = query.getProjectVars();
        if (vars.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 var expected");
        }
        Var result = (Var)vars.get(0);
        return result;
    }

    public static boolean shouldDisablePatternReorder(Query query) {
        Op op = Algebra.toQuadForm((Op)Algebra.compile((Query)query));
        Set<Op> ops = TransformCollectOps.collect(op, false);
        boolean containsService = ops.stream().anyMatch(x -> x instanceof OpService);
        Set usedUdpfs = ops.stream().flatMap(OpVisitorTriplesQuads::streamQuads).map(quad -> quad.getPredicate()).filter(Node::isURI).map(Node::getURI).filter(uri -> PropertyFunctionRegistry.get().get(uri) != null).collect(Collectors.toSet());
        boolean usesUdpf = !usedUdpfs.isEmpty();
        boolean result = containsService || usesUdpf;
        return result;
    }

    public static Query restrictToLimit(Query query, long limit, boolean cloneOnChange) {
        Query result = query;
        if (limit != Long.MIN_VALUE) {
            long adjustedLimit;
            long queryLimit = query.getLimit();
            long l = adjustedLimit = queryLimit == Long.MIN_VALUE ? limit : Math.min(limit, queryLimit);
            if (adjustedLimit != queryLimit) {
                if (cloneOnChange) {
                    result = result.cloneQuery();
                }
                result.setLimit(adjustedLimit);
            }
        }
        return result;
    }
}

