/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.prefix;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.util.SplitIRI;

public class ShortNameMgr {
    protected int namespaceCounter = 0;
    protected PrefixMap prefixMap = PrefixMapFactory.createForOutput();
    protected Map<String, Name> shortToFull = new HashMap<String, Name>();
    protected Function<String, String> shortNameSanitizer;

    public ShortNameMgr() {
        this(null);
    }

    public ShortNameMgr(Function<String, String> shortNameSanitizer) {
        this.shortNameSanitizer = shortNameSanitizer;
    }

    public Name allocate(String iri, String label) {
        String localName;
        String ns;
        Pair pair = this.prefixMap.abbrev(iri);
        String prefix = null;
        if (pair != null) {
            prefix = (String)pair.getLeft();
            ns = this.prefixMap.get(prefix);
            localName = (String)pair.getRight();
        } else {
            int splitPoint = SplitIRI.splitpoint((String)iri);
            if (splitPoint < 0) {
                splitPoint = iri.length();
            }
            ns = iri.substring(0, splitPoint);
            localName = iri.substring(splitPoint);
        }
        if (label != null) {
            localName = label;
        }
        return this.allocate(prefix, ns, localName);
    }

    public Name allocate(String iri) {
        return this.allocate(iri, null);
    }

    protected Name allocate(String prefix, String ns, String localName) {
        String baseName = localName;
        if (baseName.isEmpty()) {
            baseName = "_";
        }
        Object shortName = this.shortNameSanitizer == null ? baseName : this.shortNameSanitizer.apply(baseName);
        Name result = null;
        int i = 0;
        while ((result = this.shortToFull.get(shortName)) != null && !result.ns().equals(ns)) {
            shortName = baseName + i;
            ++i;
        }
        if (result == null) {
            prefix = this.allocPrefix(ns);
            this.prefixMap.add(prefix, ns);
            result = new Name((String)shortName, prefix, ns, localName);
            this.shortToFull.put((String)shortName, result);
        }
        return result;
    }

    protected String allocPrefix(String ns) {
        return "ns" + ++this.namespaceCounter;
    }

    public record Name(String shortName, String prefix, String ns, String localName) {
    }
}

