/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.prefix;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.lib.Trie;
import org.apache.jena.sparql.graph.PrefixMappingBase;

public class PrefixMappingTrie
extends PrefixMappingBase {
    private Map<String, String> prefixToUri = new ConcurrentHashMap<String, String>();
    private Trie<String> uriToPrefix = new Trie();
    private Cache<String, Optional<String>> longestMatchCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public Optional<Map.Entry<String, String>> findMapping(String uri, boolean partial) {
        String prefix;
        try {
            prefix = partial ? (String)((Optional)this.longestMatchCache.get((Object)uri, () -> Optional.ofNullable((String)this.uriToPrefix.longestMatch(uri)))).orElse(null) : (String)this.uriToPrefix.get(uri);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected failure during cache lookup", e);
        }
        return Optional.ofNullable(prefix).map(p -> new AbstractMap.SimpleEntry<String, String>((String)p, this.prefixToUri.get(p)));
    }

    protected void add(String prefix, String uri) {
        this.longestMatchCache.invalidateAll();
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.add(uri, (Object)prefix);
    }

    protected void remove(String prefix) {
        this.longestMatchCache.invalidateAll();
        String u = this.prefixToUri(prefix);
        if (u == null) {
            return;
        }
        String p = this.findReverseMapping(u, prefix);
        this.prefixToUri.remove(prefix);
        this.uriToPrefix.remove(u);
        if (p != null) {
            this.uriToPrefix.remove(u);
        }
    }

    protected String findReverseMapping(String uri, String prefixExclude) {
        Objects.requireNonNull(prefixExclude);
        for (Map.Entry<String, String> e : this.prefixToUri.entrySet()) {
            String p = e.getKey();
            String u = e.getValue();
            if (!uri.equals(u) || prefixExclude.equals(p)) continue;
            return p;
        }
        return null;
    }

    protected void clear() {
        this.longestMatchCache.invalidateAll();
        this.prefixToUri.clear();
        this.uriToPrefix.clear();
    }

    protected boolean isEmpty() {
        return this.prefixToUri.isEmpty();
    }

    protected int size() {
        return this.prefixToUri.size();
    }

    protected String prefixToUri(String prefix) {
        return this.prefixToUri.get(prefix);
    }

    protected String uriToPrefix(String uri) {
        return (String)this.uriToPrefix.get(uri);
    }

    protected Map<String, String> asMap() {
        return this.prefixToUri;
    }

    protected Map<String, String> asMapCopy() {
        return new HashMap<String, String>(this.prefixToUri);
    }

    protected void apply(BiConsumer<String, String> action) {
        this.prefixToUri.forEach(action);
    }
}

