/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.quad;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.quad.DatasetGraphUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.Quad;

public class DatasetUtils {
    public static Stream<Node> streamNodes(Dataset ds) {
        return DatasetGraphUtils.streamNodes(ds.asDatasetGraph());
    }

    public static Iterator<Node> iterateNodes(Dataset ds) {
        return DatasetGraphUtils.iterateNodes(ds.asDatasetGraph());
    }

    public static Iterable<Map.Entry<String, Model>> listModels(Dataset dataset) {
        return () -> Stream.concat(Stream.of(Quad.defaultGraphIRI.getURI()), Streams.stream((Iterator)dataset.listNames())).map(graphName -> {
            Model m = DatasetUtils.getDefaultOrNamedModel(dataset, graphName);
            return new AbstractMap.SimpleEntry<String, Model>((String)graphName, m);
        }).filter(e -> e.getValue() != null).iterator();
    }

    public static Dataset createFromResource(Resource resource) {
        Dataset result = DatasetFactory.create();
        result.addNamedModel(resource.getURI(), resource.getModel());
        return result;
    }

    public static Model getDefaultOrNamedModel(Dataset dataset, Node graphNameNode) {
        String graphName = graphNameNode.getURI();
        Model result = DatasetUtils.getDefaultOrNamedModel(dataset, graphName);
        return result;
    }

    public static Model getDefaultOrNamedModel(Dataset dataset, String graphName) {
        Node g = NodeFactory.createURI((String)graphName);
        boolean isDefaultGraph = Quad.isDefaultGraph((Node)g);
        Model result = isDefaultGraph ? dataset.getDefaultModel() : dataset.getNamedModel(graphName);
        return result;
    }

    public static boolean containsDefaultOrNamedModel(Dataset dataset, Node graphNameNode) {
        boolean result = Optional.ofNullable(DatasetUtils.getDefaultOrNamedModel(dataset, graphNameNode)).map(model -> !model.isEmpty()).orElse(false);
        return result;
    }

    public static boolean containsDefaultOrNamedModel(Dataset dataset, String graphName) {
        boolean result = Optional.ofNullable(DatasetUtils.getDefaultOrNamedModel(dataset, graphName)).map(model -> !model.isEmpty()).orElse(false);
        return result;
    }

    public static String toString(Dataset dataset, RDFFormat rdfFormat) {
        String result;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            RDFDataMgr.write((OutputStream)out, (Dataset)dataset, (RDFFormat)rdfFormat);
            out.flush();
            result = out.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

