/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.fmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.fmt.SparqlResultFmts;
import org.aksw.jenax.arq.util.fmt.SparqlResultType;
import org.aksw.jenax.arq.util.lang.RDFLanguagesEx;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaRange;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.system.StreamRDFWriter;

public class SparqlResultFmtsImpl
implements SparqlResultFmts {
    public static final SparqlResultFmts DEFAULT = SparqlResultFmtsImpl.createDefault();
    public static final SparqlResultFmts XML = SparqlResultFmtsImpl.createXml();
    public static final SparqlResultFmts JSON = SparqlResultFmtsImpl.createJson();
    public static final SparqlResultFmts TXT = SparqlResultFmtsImpl.createTxt();
    protected Lang askResult;
    protected Lang bindings;
    protected RDFFormat triples;
    protected RDFFormat quads;
    protected Lang unknown;
    private static List<SparqlResultFmts> sisterFormats = new ArrayList<SparqlResultFmts>();

    public SparqlResultFmtsImpl(Lang unknown, Lang askResult, Lang bindings, RDFFormat triples, RDFFormat quads) {
        this.unknown = unknown;
        this.askResult = askResult;
        this.bindings = bindings;
        this.triples = triples;
        this.quads = quads;
    }

    public static SparqlResultFmts createDefault() {
        return new SparqlResultFmtsImpl(Lang.JSONLD, ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, RDFFormat.TURTLE_BLOCKS, RDFFormat.TRIG_BLOCKS);
    }

    public static SparqlResultFmts createJson() {
        return new SparqlResultFmtsImpl(Lang.JSONLD11, ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, RDFFormat.JSONLD11, RDFFormat.JSONLD11);
    }

    public static SparqlResultFmts createXml() {
        return new SparqlResultFmtsImpl(Lang.RDFXML, ResultSetLang.RS_XML, ResultSetLang.RS_XML, RDFFormat.RDFXML, RDFFormat.TRIX);
    }

    public static SparqlResultFmts createTxt() {
        return new SparqlResultFmtsImpl(Lang.TRIG, ResultSetLang.RS_Text, ResultSetLang.RS_Text, RDFFormat.TURTLE_BLOCKS, RDFFormat.TRIG_BLOCKS);
    }

    public static SparqlResultFmts createCsv() {
        return new SparqlResultFmtsImpl(Lang.NQ, ResultSetLang.RS_CSV, ResultSetLang.RS_CSV, RDFFormat.NT, RDFFormat.NQ);
    }

    public static SparqlResultFmts createTsv() {
        return new SparqlResultFmtsImpl(Lang.NQ, ResultSetLang.RS_TSV, ResultSetLang.RS_TSV, RDFFormat.NT, RDFFormat.NQ);
    }

    protected static void setSisterDefaults(SparqlResultFmtsImpl impl, SparqlResultType sourceFmt, EnumSet<SparqlResultType> targetFmts) {
        for (SparqlResultFmts f : sisterFormats) {
            if (!Objects.equals(f.get(sourceFmt), impl.get(sourceFmt))) continue;
            for (SparqlResultType s : targetFmts) {
                impl.set(s, f.get(s));
            }
        }
    }

    protected void set(SparqlResultType s, Object o) {
        switch (s) {
            case AskResult: {
                this.askResult = (Lang)o;
                return;
            }
            case Bindings: {
                this.bindings = (Lang)o;
                return;
            }
            case Quads: {
                this.quads = (RDFFormat)o;
                return;
            }
            case Triples: {
                this.triples = (RDFFormat)o;
                return;
            }
            case Unknown: {
                this.unknown = (Lang)o;
                return;
            }
        }
    }

    public static SparqlResultFmts forContentTypes(AcceptList acceptableContentTypes) {
        ArrayList mrList = new ArrayList(acceptableContentTypes.entries());
        acceptableContentTypes.entries().forEach(e -> {
            String origContentTypeStr = e.getContentTypeStr();
            Lang lang = WebContent.contentTypeToLangResultSet((String)origContentTypeStr);
            if (lang != null) {
                String contentTypeStr = lang.getContentType().getContentTypeStr();
                if (acceptableContentTypes.entries().stream().noneMatch(f -> f.getContentTypeStr().equals(contentTypeStr))) {
                    MediaRange mr = new MediaRange(e.toHeaderString().replace(origContentTypeStr, contentTypeStr));
                    mrList.add(mr);
                }
            }
        });
        AcceptList acceptList = new AcceptList(mrList);
        SparqlResultFmtsImpl r = (SparqlResultFmtsImpl)SparqlResultFmtsImpl.createDefault();
        List acceptableRdfLangs = acceptableContentTypes.entries().stream().map(MediaType::getContentTypeStr).map(RDFLanguages::contentTypeToLang).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<Lang> resultSetFormats = new ArrayList<Lang>();
        resultSetFormats.addAll(RDFLanguagesEx.getResultSetFormats());
        resultSetFormats.add(ResultSetLang.RS_Text);
        List<Lang> quadLangs = RDFLanguagesEx.getQuadLangs();
        List<Lang> tripleLangs = RDFLanguagesEx.getTripleLangs();
        r.bindings = RDFLanguagesEx.findLangMatchingAcceptList(acceptList, resultSetFormats, r.bindings);
        SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Bindings, EnumSet.of(SparqlResultType.Unknown, SparqlResultType.AskResult, SparqlResultType.Triples, SparqlResultType.Quads));
        r.askResult = RDFLanguagesEx.findLangMatchingAcceptList(acceptList, resultSetFormats, r.askResult);
        r.unknown = acceptableRdfLangs.stream().findFirst().orElse(r.unknown);
        Collection streamFormats = StreamRDFWriter.registered();
        Collection quadFormats = RDFWriterRegistry.registeredDatasetFormats();
        Collection tripleFormats = RDFWriterRegistry.registeredGraphFormats();
        boolean quadsSet = false;
        boolean triplesSet = false;
        block0: for (MediaType mt : acceptableContentTypes.entries()) {
            RDFFormatVariant formatVariant;
            RDFFormatVariant streamDefaultFormatVariant;
            Lang lang = RDFLanguages.contentTypeToLang((String)mt.getContentTypeStr());
            if (lang == null) continue;
            String variant = mt.getParameter("variant");
            RDFFormat streamDefaultFormat = StreamRDFWriter.defaultSerialization((Lang)lang);
            RDFFormatVariant rDFFormatVariant = streamDefaultFormatVariant = streamDefaultFormat != null ? streamDefaultFormat.getVariant() : null;
            if (streamDefaultFormat != null && (variant == null || streamDefaultFormatVariant != null && variant.equalsIgnoreCase(streamDefaultFormatVariant.toString()))) {
                if (!quadsSet && quadLangs.contains(lang)) {
                    r.quads = streamDefaultFormat;
                    quadsSet = true;
                    if (triplesSet) break;
                    SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Quads, EnumSet.of(SparqlResultType.Triples));
                }
                if (!triplesSet && tripleLangs.contains(lang)) {
                    r.triples = streamDefaultFormat;
                    triplesSet = true;
                    if (quadsSet) break;
                    SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Triples, EnumSet.of(SparqlResultType.Quads));
                }
            }
            for (RDFFormat f : streamFormats) {
                formatVariant = f.getVariant();
                if (!f.getLang().equals((Object)lang) || variant != null && (formatVariant == null || !variant.equalsIgnoreCase(formatVariant.toString()))) continue;
                if (!quadsSet && quadLangs.contains(lang)) {
                    r.quads = f;
                    quadsSet = true;
                    if (triplesSet) break block0;
                    SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Quads, EnumSet.of(SparqlResultType.Triples));
                }
                if (triplesSet || !tripleLangs.contains(lang)) continue;
                r.triples = f;
                triplesSet = true;
                if (quadsSet) break block0;
                SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Triples, EnumSet.of(SparqlResultType.Quads));
            }
            if (!triplesSet) {
                for (RDFFormat f : tripleFormats) {
                    formatVariant = f.getVariant();
                    if (!tripleLangs.contains(lang) || !f.getLang().equals((Object)lang) || variant != null && (formatVariant == null || !variant.equalsIgnoreCase(formatVariant.toString()))) continue;
                    r.triples = f;
                    triplesSet = true;
                    if (quadsSet) break block0;
                    SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Triples, EnumSet.of(SparqlResultType.Quads));
                    break;
                }
            }
            if (quadsSet) continue;
            for (RDFFormat f : quadFormats) {
                formatVariant = f.getVariant();
                if (!quadLangs.contains(lang) || !f.getLang().equals((Object)lang) || variant != null && (formatVariant == null || !variant.equalsIgnoreCase(formatVariant.toString()))) continue;
                r.quads = f;
                quadsSet = true;
                if (triplesSet) break block0;
                SparqlResultFmtsImpl.setSisterDefaults(r, SparqlResultType.Quads, EnumSet.of(SparqlResultType.Triples));
                continue block0;
            }
        }
        return r;
    }

    @Override
    public Lang forAskResult() {
        return this.askResult;
    }

    @Override
    public Lang forBindings() {
        return this.bindings;
    }

    @Override
    public RDFFormat forTriples() {
        return this.triples;
    }

    @Override
    public RDFFormat forQuads() {
        return this.quads;
    }

    @Override
    public Lang forUnknown() {
        return this.unknown;
    }

    static {
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_XML, ResultSetLang.RS_XML, ResultSetLang.RS_XML, RDFFormat.RDFXML_PLAIN, RDFFormat.TRIX));
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, RDFFormat.JSONLD, RDFFormat.JSONLD));
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, RDFFormat.RDFJSON, RDFFormat.JSONLD));
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, ResultSetLang.RS_JSON, RDFFormat.TURTLE_BLOCKS, RDFFormat.TRIG_BLOCKS));
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_TSV, ResultSetLang.RS_TSV, ResultSetLang.RS_TSV, RDFFormat.NT, RDFFormat.NQ));
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_CSV, ResultSetLang.RS_CSV, ResultSetLang.RS_CSV, RDFFormat.NT, RDFFormat.NQ));
        sisterFormats.add(new SparqlResultFmtsImpl(ResultSetLang.RS_Text, ResultSetLang.RS_Text, ResultSetLang.RS_Text, RDFFormat.TURTLE_BLOCKS, RDFFormat.TRIG_BLOCKS));
    }
}

