/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;

public class ClauseUtils {
    public static final Set<Expr> TRUE = Collections.singleton(NodeValue.TRUE);
    public static final Set<Expr> FALSE = Collections.singleton(NodeValue.FALSE);

    public static Set<Expr> newTrue() {
        return new LinkedHashSet<Expr>(TRUE);
    }

    public static Set<Expr> newFalse() {
        return new LinkedHashSet<Expr>(FALSE);
    }

    public static Map<Var, NodeValue> extractConstantConstraints(Collection<? extends Expr> clause) {
        HashMap<Var, NodeValue> result = new HashMap<Var, NodeValue>(clause.size());
        for (Expr expr : clause) {
            Map.Entry<Var, NodeValue> e = ExprUtils.extractConstantConstraint(expr);
            if (e == null) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static Set<Expr> signaturize(Iterable<? extends Expr> clause) {
        Set<Expr> result = StreamSupport.stream(clause.spliterator(), false).map(e -> ExprUtils.signaturize(e)).collect(Collectors.toSet());
        return result;
    }

    public static Set<Set<Expr>> filterByVars(Set<Set<Expr>> clauses, Set<Var> requiredVars) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : clauses) {
            Set<Var> clauseVars = ClauseUtils.getVarsMentioned(clause);
            if (!clauseVars.containsAll(requiredVars)) continue;
            result.add(clause);
        }
        return result;
    }

    public static boolean isSatisfiable(Set<Expr> clause) {
        for (Expr expr : clause) {
            Expr child;
            if (expr.equals((Object)NodeValue.FALSE)) {
                return false;
            }
            if (!ClauseUtils.isSatisfiable(expr)) {
                return false;
            }
            if (!(expr instanceof E_LogicalNot) || !clause.contains(child = ((E_LogicalNot)expr).getArg())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSatisfiable(Expr expr) {
        Expr exprCopy = expr.copySubstitute(BindingRoot.create());
        Expr folded = ExprTransformer.transform((ExprTransform)new ExprTransformConstantFold(), (Expr)exprCopy);
        return !folded.equals((Object)NodeValue.FALSE);
    }

    public static Set<Var> getVarsMentioned(Iterable<? extends Expr> clause) {
        HashSet<Var> result = new HashSet<Var>();
        for (Expr expr : clause) {
            result.addAll(expr.getVarsMentioned());
        }
        return result;
    }

    public static Set<Set<Expr>> applyNodeTransformSet(Set<Set<Expr>> clauses, NodeTransform nodeTransform) {
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (Set<Expr> clause : clauses) {
            Set<Expr> transformedClause = ClauseUtils.applyNodeTransform(clause, nodeTransform);
            result.add(transformedClause);
        }
        return result;
    }

    public static Set<Expr> applyNodeTransform(Set<Expr> clause, NodeTransform nodeTransform) {
        HashSet<Expr> result = new HashSet<Expr>();
        for (Expr expr : clause) {
            Expr transformedExpr = expr.applyNodeTransform(nodeTransform);
            result.add(transformedExpr);
        }
        return result;
    }
}

