/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.graph.NodeTransform;

public class TableUtils {
    public static ResultSet toResultSet(Table table) {
        return ResultSet.adapt((RowSet)table.toRowSet());
    }

    public static Table createTable(List<Var> vars, Iterable<Binding> bindings) {
        return TableUtils.createTable(vars, bindings.iterator());
    }

    public static Table createTable(List<Var> vars, Iterator<Binding> bindings) {
        Table result = TableFactory.create(vars);
        bindings.forEachRemaining(arg_0 -> ((Table)result).addBinding(arg_0));
        return result;
    }

    public static Table createTable(RowSet rs) {
        List vars = rs.getResultVars();
        return TableUtils.createTable((List<Var>)vars, (Iterator<Binding>)rs);
    }

    public static Table createTable(ResultSet rs) {
        RowSet rowSet = RowSet.adapt((ResultSet)rs);
        return TableUtils.createTable(rowSet);
    }

    public static Table createTable(Var var, Iterable<Node> nodesIt) {
        return TableUtils.createTable(var, nodesIt);
    }

    public static Table createTable(Var var, Iterator<Node> nodesIt) {
        Table result = TableFactory.create(Arrays.asList(var));
        while (nodesIt.hasNext()) {
            Node node = nodesIt.next();
            result.addBinding(BindingFactory.binding((Var)var, (Node)node));
        }
        return result;
    }

    @Deprecated
    public static Table applyNodeTransform(Table table, NodeTransform transform) {
        List oldVars = table.getVars();
        ArrayList<Var> newVars = new ArrayList<Var>(oldVars.size());
        for (Var o : oldVars) {
            Var n = (Var)transform.apply((Object)o);
            newVars.add(n);
        }
        TableN result = new TableN(newVars);
        Iterator it = table.rows();
        while (it.hasNext()) {
            Binding o = (Binding)it.next();
            Binding n = BindingUtils.transformKeys(o, transform);
            result.addBinding(n);
        }
        return result;
    }
}

