/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple;

import com.google.common.base.Converter;
import java.util.stream.Stream;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.commons.tuple.finder.TupleFinder;
import org.aksw.jenax.arq.util.tuple.ConverterTuple;

public class TupleFinderMapper<ID, IC, OD, OC>
implements TupleFinder<ID, IC> {
    protected TupleFinder<OD, OC> backend;
    protected Converter<IC, OC> componentConverter;
    protected TupleBridge<ID, IC> inBridge;

    protected TupleFinderMapper(TupleFinder<OD, OC> backend, Converter<IC, OC> componentConverter, TupleBridge<ID, IC> inBridge) {
        this.backend = backend;
        this.componentConverter = componentConverter;
        this.inBridge = inBridge;
    }

    public static <ID, IC, OD, OC> TupleFinder<ID, IC> wrap(TupleFinder<OD, OC> backend, Converter<IC, OC> componentConverter, TupleBridge<ID, IC> inBridge) {
        return new TupleFinderMapper<ID, IC, OD, OC>(backend, componentConverter, inBridge);
    }

    public TupleBridge<ID, IC> getTupleBridge() {
        return this.inBridge;
    }

    public <X> Stream<ID> find(X tuple, TupleAccessor<? super X, ? extends IC> accessor) {
        Object backendTuple = ConverterTuple.convert(tuple, accessor, arg_0 -> this.componentConverter.convert(arg_0), this.backend.getTupleBridge());
        Stream base = this.backend.find(backendTuple);
        Stream<Object> result = base.map(t -> ConverterTuple.convert(t, this.backend.getTupleBridge(), arg_0 -> ((Converter)this.componentConverter.reverse()).convert(arg_0), this.inBridge));
        return result;
    }
}

