/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.exec.query.ExecutionContextUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.triple.TripleConstraint;
import org.aksw.jenax.arq.util.triple.TripleConstraintImpl;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;

public class TripleFilter
implements Predicate<Triple> {
    protected Triple triplePattern;
    protected ExprList exprs;
    protected boolean isForward;

    public TripleFilter(Triple triplePattern, ExprList exprs, boolean isForward) {
        this.triplePattern = triplePattern;
        this.exprs = exprs;
        this.isForward = isForward;
    }

    public static TripleFilter create(Node source, Node predicate, boolean isForward) {
        return new TripleFilter(Triple.create((Node)source, (Node)predicate, (Node)Vars.o), null, isForward);
    }

    public Node getSource() {
        return TripleUtils.getSource(this.triplePattern, this.isForward);
    }

    public Node getTarget() {
        return TripleUtils.getTarget(this.triplePattern, this.isForward);
    }

    public Triple getTriplePattern() {
        return this.triplePattern;
    }

    public ExprList getExprs() {
        return this.exprs;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public Boolean evalExpr(Triple triple) {
        Boolean result = Boolean.TRUE;
        Binding binding = TripleUtils.tripleToBinding(this.triplePattern, triple);
        ExecutionContext execCxt = ExecutionContextUtils.createFunctionEnv();
        if (binding != null && this.exprs != null) {
            for (Expr expr : this.exprs) {
                NodeValue nv = ExprLib.evalOrNull((Expr)expr, (Binding)binding, (FunctionEnv)execCxt);
                if (nv == null) {
                    result = true;
                    break;
                }
                if (!nv.isBoolean() || nv.getBoolean()) continue;
                result = Boolean.FALSE;
                break;
            }
        }
        return result;
    }

    public TripleFilter bind(Binding binding) {
        boolean isChanged;
        TripleFilter result = this;
        boolean bl = isChanged = !binding.isEmpty();
        if (isChanged) {
            NodeTransform xform = NodeTransformLib2.wrapWithNullAsIdentity(n -> n.isVariable() ? binding.get((Var)n) : null);
            Triple newPattern = NodeTransformLib.transform((NodeTransform)xform, (Triple)this.triplePattern);
            ExprList newExprs = this.exprs == null ? null : new ExprList(this.exprs.getList().stream().map(expr -> expr.applyNodeTransform(xform)).map(ExprLib::foldConstants).collect(Collectors.toList()));
            result = new TripleFilter(newPattern, newExprs, this.isForward);
        }
        return result;
    }

    public TripleFilter bindSource(Node value) {
        Node source = TripleUtils.getSource(this.triplePattern, this.isForward);
        BindingBuilder bb = BindingFactory.builder();
        boolean added = NodeUtils.put(bb, source, value);
        TripleFilter result = added ? this.bind(bb.build()) : null;
        return result;
    }

    public TripleFilter bindTarget(Node value) {
        Node target = TripleUtils.getTarget(this.triplePattern, this.isForward);
        BindingBuilder bb = BindingFactory.builder();
        boolean added = NodeUtils.put(bb, target, value);
        TripleFilter result = added ? this.bind(bb.build()) : null;
        return result;
    }

    public TripleConstraint toConstraint() {
        Triple pattern = TripleUtils.create(this.getSource(), this.triplePattern.getPredicate(), this.getTarget(), this.isForward());
        TripleConstraint result = TripleConstraintImpl.create(pattern, this.exprs == null ? null : ExprUtils.andifyBalanced((Iterable<Expr>)this.exprs));
        return result;
    }

    @Override
    public boolean test(Triple triple) {
        TripleConstraint c = this.toConstraint();
        boolean result = c.test(triple);
        return result;
    }

    public String toString() {
        return "TripleFilter [triplePattern=" + String.valueOf(this.triplePattern) + ", exprs=" + String.valueOf(this.exprs) + ", isForward=" + this.isForward + "]";
    }
}

