/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphNodeRemapBase
extends GraphBase {
    protected Graph graph;
    protected NodeTransform fromGraph;
    protected NodeTransform toGraph;

    public GraphNodeRemapBase(Graph graph) {
        this.graph = graph;
    }

    public Graph getWrapped() {
        return this.graph;
    }

    public void performAdd(Triple t) {
        Triple u = NodeTransformLib.transform((NodeTransform)this.toGraph, (Triple)t);
        this.graph.add(u);
    }

    public void performDelete(Triple t) {
        Triple u = NodeTransformLib.transform((NodeTransform)this.toGraph, (Triple)t);
        this.graph.delete(u);
    }

    public static Triple createTriple(Node s, Node p, Node o) {
        Triple result = Triple.create((Node)(s == null ? Node.ANY : s), (Node)(p == null ? Node.ANY : p), (Node)(o == null ? Node.ANY : o));
        return result;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFDataMgr.write((OutputStream)out, (Graph)this, (RDFFormat)RDFFormat.NTRIPLES);
        return out.toString();
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Triple u = NodeTransformLib.transform((NodeTransform)this.toGraph, (Triple)m);
        return this.graph.find(u).mapWith(v -> NodeTransformLib.transform((NodeTransform)this.fromGraph, (Triple)v));
    }
}

