/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.quad;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.tuple.TupleUtils;
import org.aksw.jenax.arq.util.tuple.adapter.TupleBridgeQuad;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.NodeUtils;

public class QuadUtils {
    public static final String ng = "g";
    public static final String ns = "s";
    public static final String np = "p";
    public static final String no = "o";
    public static final List<String> quadVarNames = Arrays.asList("g", "s", "p", "o");
    private static final TupleSlot[] SLOTS = new TupleSlot[]{TupleSlot.GRAPH, TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT};

    public static boolean isValidAsStatement(Quad quad) {
        return quad.getGraph().isURI() && ModelUtils.isValidAsStatement((Node)quad.getSubject(), (Node)quad.getPredicate(), (Node)quad.getObject());
    }

    public static Stream<Node> streamNodes(Quad q) {
        return Stream.of(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    public static Node getNode(Quad quad, int idx) {
        switch (idx) {
            case 0: {
                return quad.getGraph();
            }
            case 1: {
                return quad.getSubject();
            }
            case 2: {
                return quad.getPredicate();
            }
            case 3: {
                return quad.getObject();
            }
        }
        throw new IndexOutOfBoundsException("Cannot access index " + idx + " of a quad");
    }

    public static Quad setNode(Quad quad, int idx, Node node) {
        switch (idx) {
            case 0: {
                return Quad.create((Node)node, (Node)quad.getSubject(), (Node)quad.getPredicate(), (Node)quad.getObject());
            }
            case 1: {
                return Quad.create((Node)quad.getGraph(), (Node)node, (Node)quad.getPredicate(), (Node)quad.getObject());
            }
            case 2: {
                return Quad.create((Node)quad.getGraph(), (Node)quad.getSubject(), (Node)node, (Node)quad.getObject());
            }
            case 3: {
                return Quad.create((Node)quad.getGraph(), (Node)quad.getSubject(), (Node)quad.getPredicate(), (Node)node);
            }
        }
        throw new IndexOutOfBoundsException("Cannot access index " + idx + " of a quad");
    }

    public static TupleSlot idxToSlot(int idx) {
        return SLOTS[idx];
    }

    public static int slotToIdx(TupleSlot slot) {
        return slot.ordinal();
    }

    public static Node getNode(Quad quad, TupleSlot slot) {
        return QuadUtils.getNode(quad, QuadUtils.slotToIdx(slot));
    }

    @Deprecated
    public static Quad applyNodeTransform(Quad quad, NodeTransform nodeTransform) {
        Node g = (Node)nodeTransform.apply((Object)quad.getGraph());
        Node s = (Node)nodeTransform.apply((Object)quad.getSubject());
        Node p = (Node)nodeTransform.apply((Object)quad.getPredicate());
        Node o = (Node)nodeTransform.apply((Object)quad.getObject());
        g = g != null ? g : quad.getGraph();
        s = s != null ? s : quad.getSubject();
        p = p != null ? p : quad.getPredicate();
        o = o != null ? o : quad.getObject();
        Quad result = new Quad(g, s, p, o);
        return result;
    }

    public static Quad applyNodeTransform(Quad quad, NodeTransform nodeTransform, boolean tg, boolean ts, boolean tp, boolean to) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node ng = tg ? (Node)nodeTransform.apply((Object)g) : g;
        Node ns = ts ? (Node)nodeTransform.apply((Object)s) : s;
        Node np = tp ? (Node)nodeTransform.apply((Object)p) : p;
        Node no = to ? (Node)nodeTransform.apply((Object)o) : o;
        Node fg = ng != null ? ng : g;
        Node fs = ns != null ? ns : s;
        Node fp = np != null ? np : p;
        Node fo = no != null ? no : o;
        Quad result = fg == g && fs == s && fp == p && fo == o ? quad : new Quad(fg, fs, fp, fo);
        return result;
    }

    public static Quad create(Node[] nodes) {
        return new Quad(nodes[0], nodes[1], nodes[2], nodes[3]);
    }

    public static Quad createMatch(Node g, Node s, Node p, Node o) {
        return new Quad(NodeUtils.nullToAny((Node)g), NodeUtils.nullToAny((Node)s), NodeUtils.nullToAny((Node)p), NodeUtils.nullToAny((Node)o));
    }

    public static boolean matches(Quad pattern, Quad quad) {
        boolean result = pattern.matches(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        return result;
    }

    public static Node[] quadToArray(Quad quad) {
        return new Node[]{quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject()};
    }

    public static List<Node> quadToList(Quad quad) {
        return Arrays.asList(QuadUtils.quadToArray(quad));
    }

    public static Quad copySubstitute(Quad quad, Binding binding) {
        return Quad.create((Node)BindingUtils.substitute(quad.getGraph(), binding), (Node)BindingUtils.substitute(quad.getSubject(), binding), (Node)BindingUtils.substitute(quad.getPredicate(), binding), (Node)BindingUtils.substitute(quad.getObject(), binding));
    }

    public static Set<Var> getVarsMentioned(Quad quad) {
        return org.aksw.jenax.arq.util.node.NodeUtils.getVarsMentioned(Arrays.asList(QuadUtils.quadToArray(quad)));
    }

    public static Map<Node, Set<Quad>> partitionByGraph(Iterable<Quad> quads) {
        HashMap<Node, Set<Quad>> result = new HashMap<Node, Set<Quad>>();
        QuadUtils.partitionByGraph(quads.iterator(), result, HashSet::new);
        return result;
    }

    public static <C extends Collection<Quad>, M extends Map<Node, C>> M partitionByGraph(Iterator<Quad> it, M result, Supplier<? extends C> supplier) {
        while (it.hasNext()) {
            Quad quad = it.next();
            Node g = quad.getGraph();
            Collection qs = (Collection)result.get(g);
            if (qs == null) {
                qs = (Collection)supplier.get();
                result.put((Node)g, (Collection)qs);
            }
            qs.add(quad);
        }
        return result;
    }

    public static Map<Node, Set<Triple>> partitionByGraphTriples(Iterable<Quad> quads) {
        HashMap<Node, Set<Triple>> result = new HashMap<Node, Set<Triple>>();
        for (Quad quad : quads) {
            Node g = quad.getGraph();
            HashSet<Triple> ts = (HashSet<Triple>)result.get(g);
            if (ts == null) {
                ts = new HashSet<Triple>();
                result.put(g, ts);
            }
            Triple t = quad.asTriple();
            ts.add(t);
        }
        return result;
    }

    public static <C extends Collection<Quad>> C applyNodeTransform(C result, Collection<Quad> quads, NodeTransform nodeTransform) {
        for (Quad quad : quads) {
            Quad newQuad = QuadUtils.applyNodeTransform(quad, nodeTransform);
            result.add((Quad)newQuad);
        }
        return result;
    }

    public static Binding quadToBinding(Quad quad) {
        Binding result = BindingBuilder.create().build();
        QuadUtils.quadToBinding(quad, result);
        return result;
    }

    public static Binding quadToBinding(Quad quad, Binding parent) {
        BindingBuilder result = BindingBuilder.create((Binding)parent);
        result.add(Vars.g, quad.getGraph());
        TripleUtils.tripleToBinding(quad.asTriple(), parent);
        return result.build();
    }

    public static Binding quadToBinding(Quad pattern, Quad assignment) {
        return TupleUtils.tupleToBinding(TupleBridgeQuad.INSTANCE, pattern, assignment);
    }

    public static Element toElement(Iterable<Quad> quads) {
        Map<Node, Set<Quad>> map = QuadUtils.partitionByGraph(quads);
        Element result = QuadUtils.toElement(map);
        return result;
    }

    public static Element toElement(Map<Node, Set<Quad>> graphToQuads) {
        ElementGroup es = new ElementGroup();
        for (Map.Entry<Node, Set<Quad>> entry : graphToQuads.entrySet()) {
            ElementTriplesBlock e = new ElementTriplesBlock();
            for (Quad quad : entry.getValue()) {
                Triple triple = quad.asTriple();
                e.addTriple(triple);
            }
            Node graph = entry.getKey();
            ElementTriplesBlock f = graph == null || Quad.isDefaultGraph((Node)graph) ? e : new ElementNamedGraph(graph, (Element)e);
            es.addElement((Element)f);
        }
        ElementGroup result = es.getElements().size() == 1 ? (Element)es.getElements().get(0) : es;
        return result;
    }

    public static <C extends Collection<Quad>> C transformAll(C targetAcc, NodeTransform transform, Iterable<? extends Quad> source) {
        for (Quad quad : source) {
            Quad tgt = NodeTransformLib.transform((NodeTransform)transform, (Quad)quad);
            targetAcc.add((Quad)tgt);
        }
        return targetAcc;
    }

    public static boolean isDefaultGraph(Quad quad) {
        return quad != null && Quad.isDefaultGraph((Node)quad.getGraph());
    }
}

