/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.prefix;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.aksw.commons.collections.MapUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixEntry;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMap2
implements PrefixMap {
    protected PrefixMap global;
    protected PrefixMap local;

    public PrefixMap2(PrefixMap global, PrefixMap local) {
        this.global = Objects.requireNonNull(global);
        this.local = Objects.requireNonNull(local);
    }

    public PrefixMap getGlobal() {
        return this.global;
    }

    public PrefixMap getLocal() {
        return this.local;
    }

    public String get(String prefix) {
        String result = this.local.get(prefix);
        if (result == null) {
            result = this.global.get(prefix);
        }
        return result;
    }

    public Map<String, String> getMapping() {
        return MapUtils.union((Map)this.global.getMapping(), (Map)this.local.getMapping());
    }

    public Map<String, String> getMappingCopy() {
        Map result = this.global.getMappingCopy();
        result.putAll(this.local.getMapping());
        return result;
    }

    public void forEach(BiConsumer<String, String> action) {
        this.getMapping().forEach(action);
    }

    public Stream<PrefixEntry> stream() {
        return this.getMapping().entrySet().stream().map(e -> PrefixEntry.create((String)((String)e.getKey()), (String)((String)e.getValue())));
    }

    public void add(String prefix, String iriString) {
        this.local.add(prefix, iriString);
    }

    public void putAll(PrefixMap pmap) {
        this.local.putAll(pmap);
    }

    public void putAll(PrefixMapping pmap) {
        this.local.putAll(pmap);
    }

    public void putAll(Map<String, String> mapping) {
        this.local.putAll(mapping);
    }

    public void delete(String prefix) {
        this.local.delete(prefix);
    }

    public void clear() {
        this.local.clear();
    }

    public boolean containsPrefix(String prefix) {
        return this.local.containsPrefix(prefix) || this.global.containsPrefix(prefix);
    }

    public String abbreviate(String uriStr) {
        String result = this.local.abbreviate(uriStr);
        if (result == null) {
            result = this.global.abbreviate(uriStr);
        }
        return result;
    }

    public Pair<String, String> abbrev(String uriStr) {
        Pair result = this.local.abbrev(uriStr);
        if (result == null) {
            result = this.global.abbrev(uriStr);
        }
        return result;
    }

    public String expand(String prefixedName) {
        String result = this.local.expand(prefixedName);
        if (result == null) {
            result = this.global.expand(prefixedName);
        }
        return result;
    }

    public String expand(String prefix, String localName) {
        String result = this.local.expand(prefix, localName);
        if (result == null) {
            result = this.global.expand(prefix, localName);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.global.isEmpty() && this.local.isEmpty();
    }

    public int size() {
        return this.getMapping().size();
    }
}

