/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.BlankNodeAllocator;

public class BlankNodeAllocatorAsGivenOrRandom
implements BlankNodeAllocator {
    public static final String BNodeGenIdPrefix = "genid";
    private static transient BlankNodeAllocatorAsGivenOrRandom GLOBAL_INSTANCE = null;
    protected final long globalBnodeScope;
    protected final AtomicLong counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlankNodeAllocatorAsGivenOrRandom getGlobalInstance() {
        if (GLOBAL_INSTANCE != null) return GLOBAL_INSTANCE;
        Class<BlankNodeAllocatorAsGivenOrRandom> clazz = BlankNodeAllocatorAsGivenOrRandom.class;
        synchronized (BlankNodeAllocatorAsGivenOrRandom.class) {
            if (GLOBAL_INSTANCE != null) return GLOBAL_INSTANCE;
            long globalId = Math.abs(new Random().nextLong());
            GLOBAL_INSTANCE = new BlankNodeAllocatorAsGivenOrRandom(globalId);
            // ** MonitorExit[var0] (shouldn't be in output)
            return GLOBAL_INSTANCE;
        }
    }

    public BlankNodeAllocatorAsGivenOrRandom(long globalBnodeScope) {
        this(globalBnodeScope, new AtomicLong());
    }

    public BlankNodeAllocatorAsGivenOrRandom(long globalBnodeScope, AtomicLong counter) {
        this.globalBnodeScope = globalBnodeScope;
        this.counter = counter;
    }

    public void reset() {
    }

    public Node alloc(String label) {
        return NodeFactory.createBlankNode((String)label);
    }

    public Node create() {
        long x = this.counter.getAndIncrement();
        String label = "genid_" + this.globalBnodeScope + "_" + x;
        return NodeFactory.createBlankNode((String)label);
    }
}

