/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.io;

import java.io.OutputStream;
import java.util.Objects;
import org.aksw.jenax.arq.util.io.ToDatasetGraph;
import org.aksw.jenax.arq.util.io.ToGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.sparql.core.DatasetGraph;

public interface StreamRDFEmitter
extends ToGraph,
ToDatasetGraph {
    public void emit(StreamRDF var1);

    default public void output(OutputStream out, Lang lang) {
        StreamRDF streamRDF = StreamRDFWriter.getWriterStream((OutputStream)out, (Lang)lang);
        streamRDF.start();
        this.emit(streamRDF);
        streamRDF.finish();
    }

    @Override
    default public Graph toGraph(Graph graph) {
        return this.toGraph(graph, this);
    }

    default public Graph toGraph(Graph destination, StreamRDFEmitter emitter) {
        Objects.requireNonNull(destination);
        StreamRDF sink = StreamRDFLib.graph((Graph)destination);
        sink.start();
        emitter.emit(sink);
        sink.finish();
        return destination;
    }

    @Override
    default public DatasetGraph toDatasetGraph(DatasetGraph datasetGraph) {
        return this.toDatasetGraph(datasetGraph, this);
    }

    default public DatasetGraph toDatasetGraph(DatasetGraph destination, StreamRDFEmitter emitter) {
        Objects.requireNonNull(destination);
        StreamRDF sink = StreamRDFLib.dataset((DatasetGraph)destination);
        sink.start();
        emitter.emit(sink);
        sink.finish();
        return destination;
    }
}

