/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.streamrdf;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.aksw.commons.util.concurrent.CompletionTracker;
import org.aksw.jenax.arq.util.prefix.PrefixMappingTrie;
import org.aksw.jenax.arq.util.update.UpdateRequestUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;

public class StreamRDFToUpdateRequest
implements StreamRDF {
    public static final int DEFAULT_BATCH_SIZE = 100;
    protected BlockingQueue<Quad> queue = new LinkedBlockingQueue<Quad>();
    protected int batchSize;
    protected Node graphNode = Quad.defaultGraphIRI;
    protected ReadWriteLock prologueLock = new ReentrantReadWriteLock();
    protected CompletionTracker completionTracker;
    protected Consumer<UpdateRequest> insertHandler;
    protected Prologue prologue;

    public StreamRDFToUpdateRequest(Prologue prologue, int batchSize, ExecutorService executorService, Consumer<UpdateRequest> insertHandler) {
        this.prologue = prologue;
        this.batchSize = batchSize;
        this.insertHandler = insertHandler;
        this.completionTracker = new CompletionTracker((Executor)executorService);
    }

    public static StreamRDF createWithTrie(int batchSize, ExecutorService executorService, Consumer<UpdateRequest> insertHandler) {
        return new StreamRDFToUpdateRequest(new Prologue((PrefixMapping)new PrefixMappingTrie()), batchSize, executorService, insertHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBatch() {
        ArrayList quads = new ArrayList();
        this.queue.drainTo(quads);
        UpdateRequest ur = new UpdateRequest((Update)new UpdateDataInsert(new QuadDataAcc(quads)));
        Lock readLock = this.prologueLock.readLock();
        try {
            readLock.lock();
            PrefixMappingTrie pm = new PrefixMappingTrie();
            pm.setNsPrefixes(this.prologue.getPrefixMapping());
            ur.setPrefixMapping((PrefixMapping)pm);
            String base = this.prologue.getBaseURI();
            if (base != null) {
                ur.setBaseURI(base);
            }
        }
        finally {
            readLock.unlock();
        }
        this.completionTracker.execute(() -> {
            UpdateRequestUtils.optimizePrefixes(ur);
            this.insertHandler.accept(ur);
        });
    }

    public void checkSendBatch() {
        if (this.queue.size() > this.batchSize) {
            this.sendBatch();
        }
    }

    public void start() {
    }

    public void triple(Triple triple) {
        this.quad(new Quad(this.graphNode, triple));
    }

    public void quad(Quad quad) {
        this.queue.add(quad);
        this.checkSendBatch();
    }

    public void base(String base) {
        this.sendBatch();
        Lock writeLock = this.prologueLock.writeLock();
        try {
            writeLock.lock();
            this.prologue.setBaseURI(base);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefix(String prefix, String iri) {
        Lock writeLock = this.prologueLock.writeLock();
        try {
            writeLock.lock();
            this.prologue.setPrefix(prefix, iri);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void finish() {
        this.sendBatch();
        this.completionTracker.shutdown();
        try {
            this.completionTracker.awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void abort() {
    }
}

