/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.streamrdf;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapAdapter;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFDeferred
implements StreamRDF {
    protected StreamRDF delegate;
    protected List<Quad> deferredData;
    protected Node mostRecentTripleSubject = null;
    protected Node mostRecentQuadGraph = null;
    protected boolean allowExtendBasePrefixes = true;
    protected PrefixMapping basePrefixes;
    protected PrefixMapping usedPrefixes = new PrefixMappingImpl();
    protected PrefixMap usedPrefixAdapter = new PrefixMapAdapter(this.usedPrefixes);
    protected long remainingQuadDeferrals;
    protected long remainingBatchDeferrals;
    protected String base = null;

    public StreamRDFDeferred(StreamRDF delegate, boolean allowExtendBasePrefixes, PrefixMapping basePrefixes, long remainingBatchDeferrals, long remainingQuadDeferrals, String base) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.allowExtendBasePrefixes = allowExtendBasePrefixes;
        this.basePrefixes = basePrefixes;
        this.remainingQuadDeferrals = remainingQuadDeferrals;
        this.remainingBatchDeferrals = remainingBatchDeferrals;
        this.base = base;
        if (remainingBatchDeferrals <= 0L || remainingQuadDeferrals <= 0L) {
            this.remainingBatchDeferrals = 0L;
            this.remainingQuadDeferrals = 0L;
        }
        this.deferredData = remainingQuadDeferrals > 1L ? new ArrayList() : null;
    }

    public void triple(Triple triple) {
        if (this.remainingQuadDeferrals > 0L) {
            this.quad(Quad.create((Node)Quad.defaultGraphIRI, (Triple)triple));
        } else {
            this.delegate.triple(triple);
        }
    }

    public void quad(Quad quad) {
        if (this.remainingQuadDeferrals > 0L) {
            QuadUtils.streamNodes(quad).forEach(node -> PrefixUtils.usedPrefixes(node, this.basePrefixes, this.usedPrefixes));
            --this.remainingQuadDeferrals;
            if (this.remainingQuadDeferrals == 0L) {
                this.sendDeferredData();
                this.delegate.quad(quad);
            } else {
                Node quadGraph = quad.getGraph();
                Node tripleSubject = quad.getSubject();
                boolean isConsecutiveGraph = Objects.equals(this.mostRecentQuadGraph, quadGraph);
                boolean isConsecutiveTuple = isConsecutiveGraph && !Quad.isDefaultGraph((Node)quadGraph) || Objects.equals(this.mostRecentTripleSubject, tripleSubject);
                this.mostRecentQuadGraph = quadGraph;
                this.mostRecentTripleSubject = tripleSubject;
                if (!isConsecutiveTuple) {
                    --this.remainingBatchDeferrals;
                    if (this.remainingBatchDeferrals == 0L) {
                        this.sendDeferredData();
                        this.delegateTripleOrQuad(quad);
                    } else {
                        this.deferredData.add(quad);
                    }
                } else {
                    this.deferredData.add(quad);
                }
            }
        } else {
            this.delegate.quad(quad);
        }
    }

    public void delegateTripleOrQuad(Quad quad) {
        if (Quad.isDefaultGraph((Node)quad.getGraph())) {
            this.delegate.triple(quad.asTriple());
        } else {
            this.delegate.quad(quad);
        }
    }

    public void sendDeferredData() {
        if (this.deferredData == null) {
            return;
        }
        if (this.base != null) {
            this.delegate.base(this.base);
        }
        StreamRDFOps.sendPrefixesToStream((PrefixMapping)this.usedPrefixes, (StreamRDF)this.delegate);
        for (Quad d : this.deferredData) {
            this.delegateTripleOrQuad(d);
        }
        this.remainingBatchDeferrals = 0L;
        this.remainingQuadDeferrals = 0L;
        this.deferredData = null;
    }

    public void base(String base) {
        if (this.base == null) {
            this.base = base;
        }
    }

    public void prefix(String prefix, String iri) {
        if (this.remainingQuadDeferrals > 0L && this.allowExtendBasePrefixes) {
            this.basePrefixes.setNsPrefix(prefix, iri);
        }
    }

    public void start() {
        this.delegate.start();
    }

    public void finish() {
        this.sendDeferredData();
        this.delegate.finish();
    }
}

