/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.query;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TransformList<X, Y extends Function<X, X>>
implements Function<X, X> {
    protected List<Y> mods;

    public TransformList(List<Y> mods) {
        this.mods = List.copyOf(mods);
    }

    public List<Y> getMods() {
        return this.mods;
    }

    @Override
    public X apply(X t) {
        Object result = t;
        for (Function mod : this.mods) {
            Object next = mod.apply(result);
            result = next;
        }
        return result;
    }

    public static <X, Y extends Function<X, X>> Stream<Y> streamFlatten(boolean recursive, Y transform) {
        Stream<Object> result;
        if (transform instanceof TransformList) {
            result = ((TransformList)transform).getMods().stream();
            if (recursive) {
                result = result.flatMap(x -> TransformList.streamFlatten(recursive, x));
            }
        } else {
            result = Stream.of(transform);
        }
        return result;
    }

    public static <X, Y extends Function<X, X>> Y flattenOrNull(boolean recursive, Function<List<Y>, Y> ctor, Stream<Y> rewrites) {
        List list = rewrites.flatMap(item -> TransformList.streamFlatten(recursive, item)).collect(Collectors.toList());
        Function result = list.isEmpty() ? null : (list.size() == 1 ? (Function)list.get(0) : (Function)ctor.apply(list));
        return (Y)result;
    }

    public static <X, Y extends Function<X, X>> Y flatten(boolean recursive, Function<List<Y>, Y> ctor, Stream<Y> rewrites) {
        Object result = TransformList.flattenOrNull(recursive, ctor, rewrites);
        if (result == null) {
            result = (Function)ctor.apply(List.of());
        }
        return result;
    }

    public String toString() {
        return Objects.toString(this.mods);
    }
}

