/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.quad;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.node.NodeTransformSignaturize;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.util.NodeCmp;

public class QuadPatternUtils {
    public static QuadPattern signaturize(QuadPattern quadPattern) {
        NodeTransform nodeTransform = NodeTransformSignaturize.create();
        QuadPattern result = NodeTransformLib.transform((NodeTransform)nodeTransform, (QuadPattern)quadPattern);
        return result;
    }

    public static QuadPattern signaturize(QuadPattern quadPattern, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap baseTransform = NodeTransformRenameMap.create(nodeMap);
        NodeTransform nodeTransform = NodeTransformSignaturize.create(baseTransform);
        QuadPattern result = NodeTransformLib.transform((NodeTransform)nodeTransform, (QuadPattern)quadPattern);
        return result;
    }

    public static QuadPattern create(Iterable<Quad> quads) {
        QuadPattern result = new QuadPattern();
        for (Quad quad : quads) {
            result.add(quad);
        }
        return result;
    }

    public static QuadPattern toQuadPattern(BasicPattern basicPattern) {
        return QuadPatternUtils.toQuadPattern(Quad.defaultGraphNodeGenerated, basicPattern);
    }

    public static QuadPattern toQuadPattern(Node g, BasicPattern basicPattern) {
        QuadPattern result = new QuadPattern();
        for (Triple triple : basicPattern) {
            Quad quad = new Quad(g, triple);
            result.add(quad);
        }
        return result;
    }

    public static BasicPattern toBasicPattern(QuadPattern quadPattern) {
        BasicPattern result = new BasicPattern();
        for (Quad quad : quadPattern) {
            Triple triple = quad.asTriple();
            result.add(triple);
        }
        return result;
    }

    public static Map<Node, BasicPattern> indexBasicPattern(Iterable<Quad> quads) {
        HashMap<Node, BasicPattern> result = new HashMap<Node, BasicPattern>();
        for (Quad q : quads) {
            BasicPattern basicPattern = (BasicPattern)result.get(q.getGraph());
            if (basicPattern == null) {
                basicPattern = new BasicPattern();
                result.put(q.getGraph(), basicPattern);
            }
            basicPattern.add(q.asTriple());
        }
        return result;
    }

    public static Map<Node, Set<Triple>> indexSorted(Iterable<Quad> quads) {
        TreeMap<Node, Set<Triple>> result = new TreeMap<Node, Set<Triple>>(NodeCmp::compareRDFTerms);
        for (Quad q : quads) {
            TreeSet<Triple> triples = (TreeSet<Triple>)result.get(q.getGraph());
            if (triples == null) {
                triples = new TreeSet<Triple>(TripleUtils::compareRDFTerms);
                result.put(q.getGraph(), triples);
            }
            triples.add(q.asTriple());
        }
        return result;
    }

    public static Map<Node, Graph> indexAsGraphs(Iterable<? extends Quad> quads) {
        Map<Node, Graph> result = QuadPatternUtils.indexAsGraphs(quads.iterator());
        return result;
    }

    public static Map<Node, Graph> indexAsGraphs(Iterator<? extends Quad> it) {
        LinkedHashMap<Node, Graph> result = new LinkedHashMap<Node, Graph>();
        Graph activeGraph = null;
        Node activeG = NodeFactory.createBlankNode();
        while (it.hasNext()) {
            Quad quad = it.next();
            Node g = quad.getGraph();
            if (!Objects.equals(g, activeG)) {
                activeGraph = result.computeIfAbsent(g, x -> GraphFactory.createDefaultGraph());
                activeG = g;
            }
            activeGraph.add(quad.asTriple());
        }
        return result;
    }

    public static Resource createResourceFromQuads(Collection<? extends Quad> quads) {
        Map<Node, Graph> index = QuadPatternUtils.indexAsGraphs(quads);
        if (index.isEmpty()) {
            throw new RuntimeException("At least one quad expected");
        }
        if (index.size() > 1) {
            throw new RuntimeException("All quads must have the same graph");
        }
        Map.Entry<Node, Graph> e = index.entrySet().iterator().next();
        Node sn = e.getKey();
        Graph g = e.getValue();
        Model m = ModelFactory.createModelForGraph((Graph)g);
        Resource result = m.asRDFNode(sn).asResource();
        return result;
    }

    public static Set<Var> getVarsMentioned(Iterable<? extends Quad> quadPattern) {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        for (Quad quad : quadPattern) {
            Set<Var> tmp = QuadUtils.getVarsMentioned(quad);
            result.addAll(tmp);
        }
        return result;
    }

    public static boolean isDefaultGraphOnly(Iterable<? extends Quad> quadPattern) {
        boolean result = true;
        for (Quad quad : quadPattern) {
            if (QuadUtils.isDefaultGraph(quad)) continue;
            result = false;
            break;
        }
        return result;
    }
}

