/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;

public class ReverseRenameUtils {
    public static String plainVarName(Node node) {
        return ReverseRenameUtils.plainVarName(node.getName());
    }

    public static String plainVarName(String rawName) {
        return ReverseRenameUtils.separateMarkerFromVarName(rawName)[1];
    }

    public static String[] separateMarkerFromVarName(String rawName) {
        String[] result = new String[]{"", null};
        if (Var.isAllocVarName((String)rawName)) {
            result[0] = ".";
            result[1] = rawName.substring(".".length());
        } else if (Var.isBlankNodeVarName((String)rawName)) {
            result[0] = "?";
            result[1] = rawName.substring("?".length());
        } else if (Var.isRenamedVar((String)rawName)) {
            result[0] = "/";
            result[1] = rawName.substring("/".length());
        } else {
            result[1] = rawName;
        }
        return result;
    }

    public static Node effectiveNode(Node node) {
        Node result;
        if (Var.isVar((Node)node)) {
            String rawName = node.getName();
            String name = ReverseRenameUtils.separateMarkerFromVarName(rawName)[1];
            result = Var.isBlankNodeVar((Node)node) || Var.isAllocVar((Node)node) ? NodeFactory.createBlankNode((String)name) : node;
        } else {
            result = node;
        }
        return result;
    }

    public static Triple effectiveTriple(Triple t) {
        return Triple.create((Node)ReverseRenameUtils.effectiveNode(t.getSubject()), (Node)ReverseRenameUtils.effectiveNode(t.getPredicate()), (Node)ReverseRenameUtils.effectiveNode(t.getObject()));
    }
}

