/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import java.math.BigDecimal;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.NodeCmp;

public class NodeValueUtils {
    public static final NodeValue NV_ABSENT = NodeValue.makeNode((Node)NodeUtils.nullUriNode);

    public static int compareAlways(NodeValue o1, NodeValue o2) {
        int result;
        try {
            result = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : NodeValue.compareAlways((NodeValue)o1, (NodeValue)o2));
        }
        catch (Exception e) {
            result = NodeCmp.compareRDFTerms((Node)o1.asNode(), (Node)o2.asNode());
        }
        return result;
    }

    public static int getInteger(NodeValue expr) {
        int result;
        if (expr.isInteger()) {
            result = expr.getInteger().intValue();
        } else if (expr.isDecimal()) {
            result = expr.getDecimal().intValue();
        } else {
            throw new RuntimeException("Not an integer value: " + String.valueOf(expr));
        }
        return result;
    }

    public static Number getNumber(NodeValue expr) {
        Object obj = NodeValueUtils.getValue(expr);
        Number result = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
        return result;
    }

    public static Object getValue(NodeValue expr) {
        if (expr == null) {
            return Expr.NONE;
        }
        if (expr.isIRI()) {
            return expr.asNode().getURI();
        }
        if (expr.isBoolean()) {
            return expr.getBoolean();
        }
        if (expr.isNumber()) {
            if (expr.isDecimal()) {
                BigDecimal d = expr.getDecimal();
                if (d.scale() > 0) {
                    return d.doubleValue();
                }
                return d.intValue();
            }
            if (expr.isDouble()) {
                return expr.getDouble();
            }
            if (expr.isFloat()) {
                return Float.valueOf(expr.getFloat());
            }
            return expr.getDecimal().longValue();
        }
        if (expr.isString()) {
            return expr.getString();
        }
        if (expr.isDateTime()) {
            return expr.getDateTime();
        }
        throw new RuntimeException("Unknow datatype of constant: " + String.valueOf(expr));
    }
}

