/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.expr;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aksw.commons.util.algebra.ExprFilter;
import org.aksw.commons.util.algebra.GenericFactorizer;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.jenax.arq.util.expr.ExprListUtils;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.node.NodeTransformSignaturize;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.FunctionLabel;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.graph.NodeTransformLib;

public class ExprUtils {
    private static final ExprOps exprOps = new ExprOps();

    public static ExprOps getExprOps() {
        return exprOps;
    }

    public static Expr getIsNotBoundArg(Expr expr) {
        Expr result = ObjectUtils.tryCastAs(E_LogicalNot.class, (Object)expr).flatMap(not -> ObjectUtils.tryCastAs(E_Bound.class, (Object)not.getArg())).orElse(null);
        return result;
    }

    public static Set<Node> nodesMentioned(Expr expr) {
        NodeTransformCollectNodes nodeTransform = new NodeTransformCollectNodes();
        expr.applyNodeTransform((NodeTransform)nodeTransform);
        Set<Node> result = nodeTransform.getNodes();
        return result;
    }

    public static boolean containsExprAggregator(Expr expr) {
        ContainsExprAggregator xform = new ContainsExprAggregator();
        ExprTransformer.transform((ExprTransform)xform, (Expr)expr);
        boolean result = xform.seenExprAggregator();
        return result;
    }

    public static boolean isSame(Node node, Expr expr) {
        boolean result = node.isVariable() ? expr.isVariable() && node.equals((Object)expr.asVar()) : (node.isConcrete() ? expr.isConstant() && node.equals((Object)expr.getConstant().asNode()) : false);
        return result;
    }

    public static Expr applyNodeTransform(Expr expr, NodeTransform xform) {
        Expr result = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(node -> {
            Node r = (Node)xform.apply(node);
            return r;
        }), (Expr)expr);
        return result;
    }

    public static Expr reverseVarRename(Expr expr) {
        return ExprUtils.applyNodeTransform(expr, Rename::reverseVarRename);
    }

    public static E_OneOf oneOf(Node v, Iterable<Node> args) {
        ExprList el = new ExprList();
        el.addAll(ExprListUtils.nodesToExprs(args));
        ExprVar base = v.isVariable() ? new ExprVar(v) : NodeValue.makeNode((Node)v);
        return new E_OneOf((Expr)base, el);
    }

    public static E_OneOf oneOfIris(String varName, String ... iris) {
        List<Node> nodes = Arrays.asList(iris).stream().map(NodeFactory::createURI).collect(Collectors.toList());
        return ExprUtils.oneOf((Node)Var.alloc((String)varName), nodes);
    }

    public static E_OneOf oneOf(String varName, Collection<Node> nodes) {
        return ExprUtils.oneOf((Node)Var.alloc((String)varName), nodes);
    }

    public static E_OneOf oneOf(Node v, Node ... args) {
        return ExprUtils.oneOf(v, Arrays.asList(args));
    }

    public static E_NotOneOf notOneOf(Node v, Collection<Node> args) {
        ExprList el = new ExprList();
        el.addAll(ExprListUtils.nodesToExprs(args));
        ExprVar base = v.isVariable() ? new ExprVar(v) : NodeValue.makeNode((Node)v);
        return new E_NotOneOf((Expr)base, el);
    }

    public static E_NotOneOf notOneOf(Node v, Node ... args) {
        return ExprUtils.notOneOf(v, Arrays.asList(args));
    }

    public static <T> T applyToArgsOfBinaryExpr(Expr expr, BiFunction<? super Expr, ? super Expr, T> fn) {
        ExprFunction efn;
        List args;
        T result = null;
        if (expr.isFunction() && (args = (efn = expr.getFunction()).getArgs()).size() == 2) {
            result = fn.apply((Expr)args.get(0), (Expr)args.get(1));
        }
        return result;
    }

    public static Map.Entry<NodeValue, Expr> tryGetConstAndExpr(Expr a, Expr b) {
        AbstractMap.SimpleEntry<NodeValue, Expr> result = null;
        if (a.isConstant()) {
            result = new AbstractMap.SimpleEntry<NodeValue, Expr>(a.getConstant(), b);
        } else if (b.isConstant()) {
            result = new AbstractMap.SimpleEntry<NodeValue, Expr>(b.getConstant(), a);
        }
        return result;
    }

    public static Map.Entry<Var, Node> tryGetVarConst(Expr a, Expr b) {
        Var v = a.isVariable() ? a.asVar() : (Var)Optional.of(a).filter(Expr::isConstant).map(Expr::getConstant).map(NodeValue::asNode).filter(Node::isVariable).map(n -> (Var)n).orElse(null);
        Map.Entry result = v != null && b.isConstant() ? Maps.immutableEntry((Object)v, (Object)b.getConstant().asNode()) : null;
        return result;
    }

    public static Map.Entry<Var, Var> tryGetVarVar(Expr e) {
        Expr b;
        Expr a;
        ExprFunction fn;
        List args;
        Map.Entry<Var, Var> result = null;
        if (e.isFunction() && (args = (fn = e.getFunction()).getArgs()).size() == 2 && (result = ExprUtils.tryGetVarVar(a = (Expr)args.get(0), b = (Expr)args.get(1))) == null) {
            result = ExprUtils.tryGetVarVar(b, a);
        }
        return result;
    }

    public static Map.Entry<Var, Var> tryGetVarVar(Expr a, Expr b) {
        Map.Entry result = a.isVariable() && b.isVariable() ? Maps.immutableEntry((Object)a.asVar(), (Object)b.asVar()) : null;
        return result;
    }

    public static Map.Entry<Var, Node> tryGetVarConst(Expr e) {
        Expr b;
        Expr a;
        ExprFunction fn;
        List args;
        Map.Entry<Var, Node> result = null;
        if (e.isFunction() && (args = (fn = e.getFunction()).getArgs()).size() == 2 && (result = ExprUtils.tryGetVarConst(a = (Expr)args.get(0), b = (Expr)args.get(1))) == null) {
            result = ExprUtils.tryGetVarConst(b, a);
        }
        return result;
    }

    public static int classify(Expr e) {
        int result = e.isConstant() ? 0 : (e.isVariable() ? 1 : (e.isFunction() ? 2 : 3));
        return result;
    }

    public static int compare(Expr a, Expr b) {
        int ca = ExprUtils.classify(a);
        int cb = ExprUtils.classify(b);
        int r = cb - ca;
        if (r == 0) {
            switch (ca) {
                case 0: {
                    r = NodeValue.compare((NodeValue)a.getConstant(), (NodeValue)b.getConstant());
                    break;
                }
                case 1: {
                    r = a.getVarName().compareTo(b.getVarName());
                    break;
                }
                case 2: {
                    r = a.getFunction().getFunctionIRI().compareTo(b.getFunction().getFunctionIRI());
                    break;
                }
                default: {
                    throw new RuntimeException("should not come here");
                }
            }
        }
        return r;
    }

    public static boolean isConstantsOnly(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(ExprFunction fn) {
        if (fn == null) {
            throw new RuntimeException("Null argument should not happen here");
        }
        boolean result = ExprUtils.isConstantsOnly(fn.getArgs());
        return result;
    }

    public static String getFunctionId(ExprFunction fn) {
        String result = null;
        result = fn.getOpName();
        if (result != null) {
            return result;
        }
        result = fn.getFunctionIRI();
        if (result != null) {
            return result;
        }
        FunctionLabel label = fn.getFunctionSymbol();
        result = label == null ? null : label.getSymbol();
        return result;
    }

    public static Expr applyNodeTransform(Expr expr, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap nodeTransform = NodeTransformRenameMap.create(nodeMap);
        Expr result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr);
        return result;
    }

    public static Expr andifyBalanced(Expr ... exprs) {
        return ExprUtils.andifyBalanced(Arrays.asList(exprs));
    }

    public static Expr orifyBalanced(Expr ... exprs) {
        return ExprUtils.orifyBalanced(Arrays.asList(exprs));
    }

    public static List<String> extractNames(Collection<Var> vars) {
        ArrayList<String> result = new ArrayList<String>();
        for (Var var : vars) {
            result.add(var.getName());
        }
        return result;
    }

    public static Expr andifyBalanced(Iterable<Expr> exprs) {
        Expr result = ExprUtils.opifyBalanced(exprs, (a, b) -> new E_LogicalAnd(a, b));
        return result;
    }

    public static <T> T distribute(List<T> as, List<T> bs, BinaryOperator<T> innerJunctor, BinaryOperator<T> outerJunctor) {
        ArrayList items = new ArrayList(bs.size());
        for (T a : as) {
            for (T b : bs) {
                Object item = innerJunctor.apply(a, b);
                items.add(item);
            }
        }
        Object result = ExprUtils.opifyBalanced(items, outerJunctor);
        return (T)result;
    }

    public static <T> Optional<T> opify(Iterable<T> exprs, BinaryOperator<T> exprFactory) {
        Optional result;
        Iterator<T> it = exprs.iterator();
        if (!it.hasNext()) {
            result = Optional.empty();
        } else {
            Object tmp = it.next();
            while (it.hasNext()) {
                T b = it.next();
                tmp = exprFactory.apply(tmp, b);
            }
            result = Optional.of(tmp);
        }
        return result;
    }

    public static <T> T opifyBalanced(Iterable<? extends T> exprs, BiFunction<? super T, ? super T, ? extends T> exprFactory) {
        if (!exprs.iterator().hasNext()) {
            return null;
        }
        ArrayList<T> current = Lists.newArrayList(exprs.iterator());
        while (current.size() > 1) {
            ArrayList<T> next = new ArrayList<T>();
            Object left = null;
            for (Object expr : current) {
                if (left == null) {
                    left = expr;
                    continue;
                }
                T newExpr = exprFactory.apply(left, expr);
                next.add(newExpr);
                left = null;
            }
            if (left != null) {
                next.add(left);
            }
            current.clear();
            ArrayList<T> tmp = current;
            current = next;
            ArrayList<T> arrayList = tmp;
        }
        return (T)current.get(0);
    }

    public static Expr orifyBalanced(Iterable<Expr> exprs) {
        Expr result = ExprUtils.opifyBalanced(exprs, (a, b) -> new E_LogicalOr(a, b));
        return result;
    }

    public static Map.Entry<Var, NodeValue> extractConstantConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            return ExprUtils.extractVarConstant(e.getArg1(), e.getArg2());
        }
        return null;
    }

    public static Map.Entry<Var, NodeValue> extractVarConstant(Expr expr) {
        ExprFunction f;
        Map.Entry<Var, NodeValue> result = null;
        if (expr instanceof ExprFunction && (f = expr.getFunction()).numArgs() == 2) {
            Expr a = f.getArg(1);
            Expr b = f.getArg(2);
            result = ExprUtils.extractVarConstant(a, b);
        }
        return result;
    }

    public static Map.Entry<Var, NodeValue> extractVarConstant(Expr a, Expr b) {
        Map.Entry<Var, NodeValue> result = ExprUtils.extractVarConstantDirected(a, b);
        if (result == null) {
            result = ExprUtils.extractVarConstantDirected(b, a);
        }
        return result;
    }

    public static Map.Entry<Var, NodeValue> extractVarConstantDirected(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Var var = a.getExprVar().asVar();
        NodeValue nodeValue = b.getConstant();
        return new AbstractMap.SimpleEntry<Var, NodeValue>(var, nodeValue);
    }

    public static List<Expr> getSubExprs(Expr expr) {
        List result = expr != null && expr.isFunction() ? expr.getFunction().getArgs() : Collections.emptyList();
        return result;
    }

    public static Expr signaturize(Expr expr) {
        NodeTransform nodeTransform = NodeTransformSignaturize.create();
        Expr result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr);
        return result;
    }

    public static Expr signaturize(Expr expr, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap baseTransform = NodeTransformRenameMap.create(nodeMap);
        NodeTransform nodeTransform = NodeTransformSignaturize.create(baseTransform);
        Expr result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr);
        return result;
    }

    public static <T> Stream<T> linearizePrefix(T op, Collection<T> stopMarker, Function<? super T, Iterable<? extends T>> getChildren) {
        Stream<Object> result;
        if (op == null) {
            result = Stream.empty();
        } else {
            Iterable<T> children = getChildren.apply(op);
            Stream<? extends T> x = StreamSupport.stream(children.spliterator(), false);
            result = Stream.concat(Stream.concat(StreamSupport.stream(children.spliterator(), false).flatMap(e -> ExprUtils.linearizePrefix(e, stopMarker, getChildren)), stopMarker.stream()), Stream.of(op));
        }
        return result;
    }

    public static Stream<Expr> linearizePrefix(Expr expr, Collection<Expr> stopMarkers) {
        Stream<Expr> result = ExprUtils.linearizePrefix(expr, stopMarkers, ExprUtils::getSubExprs);
        return result;
    }

    public static Expr copy(Expr proto, Expr ... args) {
        return ExprUtils.copy(proto, Arrays.asList(args));
    }

    public static Expr copy(Expr proto, List<Expr> args) {
        return ExprUtils.copy(proto, ExprList.create(args));
    }

    public static Expr copy(Expr proto, ExprList args) {
        Expr result;
        if (proto == null) {
            throw new NullPointerException();
        }
        if (proto instanceof NodeValue || proto instanceof ExprVar) {
            result = proto;
        } else if (proto instanceof ExprFunction0) {
            result = ExprUtils.copy((ExprFunction0)proto, args);
        } else if (proto instanceof ExprFunction1) {
            result = ExprUtils.copy((ExprFunction1)proto, args);
        } else if (proto instanceof ExprFunction2) {
            result = ExprUtils.copy((ExprFunction2)proto, args);
        } else if (proto instanceof ExprFunction3) {
            result = ExprUtils.copy((ExprFunction3)proto, args);
        } else if (proto instanceof ExprFunctionN) {
            result = ExprUtils.copy((ExprFunctionN)proto, args);
        } else {
            throw new IllegalArgumentException("Don't know how to handle " + String.valueOf(proto) + " of class " + String.valueOf(proto.getClass()));
        }
        return result;
    }

    public static Expr copy(ExprFunction0 func, ExprList args) {
        return func;
    }

    public static Expr copy(ExprFunction1 func, ExprList args) {
        return func.copy(args.get(0));
    }

    public static Expr copy(ExprFunction2 func, ExprList args) {
        return func.copy(args.get(0), args.get(1));
    }

    public static Expr copy(ExprFunction3 func, ExprList args) {
        return func.copy(args.get(0), args.get(1), args.get(2));
    }

    public static Expr copy(ExprFunctionN func, ExprList args) {
        return func.copy(args);
    }

    public static Expr replace(Expr expr, Function<? super Expr, ? extends Expr> fn) {
        Expr result = (Expr)org.aksw.commons.util.algebra.ExprOps.replace((org.aksw.commons.util.algebra.ExprOps)exprOps, (Object)expr, fn);
        return result;
    }

    public static Expr factorize(Expr expr, BiMap<Var, Expr> cxt, VarAlloc varAlloc, ExprFilter<Expr> isBlocker) {
        GenericFactorizer factorizer = new GenericFactorizer((org.aksw.commons.util.algebra.ExprOps)ExprUtils.getExprOps(), isBlocker);
        Expr result = (Expr)factorizer.factorize((Object)expr, cxt, () -> ((VarAlloc)varAlloc).allocVar());
        return result;
    }

    public static NodeValue[] evalToArray(List<Expr> exprs, Binding input, FunctionEnv env) {
        NodeValue[] result = new NodeValue[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            Expr expr = exprs.get(i);
            result[i] = expr.eval(input, env);
        }
        return result;
    }

    public static class ExprOps
    implements org.aksw.commons.util.algebra.ExprOps<Expr, Var> {
        public List<Expr> getSubExprs(Expr expr) {
            return ExprUtils.getSubExprs(expr);
        }

        public Expr copy(Expr proto, List<Expr> subExprs) {
            return ExprUtils.copy(proto, subExprs);
        }

        public boolean isFunction(Expr expr) {
            return expr.isFunction();
        }

        public Var asVar(Expr expr) {
            return expr.isVariable() ? expr.asVar() : null;
        }

        public Expr varToExpr(Var var) {
            return new ExprVar(var);
        }

        public String toString(Expr expr) {
            return org.apache.jena.sparql.util.ExprUtils.fmtSPARQL((Expr)expr);
        }
    }

    public static class ContainsExprAggregator
    extends ExprTransformCopy {
        protected boolean seenExprAggregator = false;

        public Expr transform(ExprAggregator eAgg) {
            this.seenExprAggregator = true;
            return super.transform(eAgg);
        }

        public boolean seenExprAggregator() {
            return this.seenExprAggregator;
        }
    }
}

