/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.binding;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.List;
import org.aksw.commons.collections.diff.ListDiff;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.binding.Binding;

public class ResultSetCompareUtils {
    public static Multiset<Binding> toMultiset(ResultSet rs) {
        HashMultiset result = HashMultiset.create();
        while (rs.hasNext()) {
            Binding original;
            Binding wrapped = original = rs.nextBinding();
            result.add((Object)wrapped);
        }
        return result;
    }

    public static ListDiff<Binding> compareOrdered(ResultSet a, ResultSet b) {
        ListDiff result = new ListDiff();
        Binding x = null;
        Binding y = null;
        while (a.hasNext()) {
            String sy;
            if (!b.hasNext()) {
                while (a.hasNext()) {
                    ((List)result.getAdded()).add(a.nextBinding());
                }
                return result;
            }
            if (x == y || x.equals(y)) {
                x = a.nextBinding();
                y = b.nextBinding();
                continue;
            }
            String sx = x.toString();
            if (sx.compareTo(sy = y.toString()) < 0) {
                ((List)result.getRemoved()).add(x);
                x = a.nextBinding();
                continue;
            }
            ((List)result.getAdded()).add(y);
            y = b.nextBinding();
        }
        while (b.hasNext()) {
            ((List)result.getRemoved()).add(b.nextBinding());
        }
        return result;
    }

    public static ListDiff<Binding> compareUnordered(ResultSet a, ResultSet b) {
        ListDiff result = new ListDiff();
        Multiset<Binding> x = ResultSetCompareUtils.toMultiset(a);
        Multiset<Binding> y = ResultSetCompareUtils.toMultiset(b);
        HashMultiset common = HashMultiset.create((Iterable)Multisets.intersection(x, y));
        y.removeAll((Collection)common);
        x.removeAll((Collection)common);
        ((List)result.getAdded()).addAll(y);
        ((List)result.getRemoved()).addAll(x);
        return result;
    }
}

