/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.var;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;

public class VarUtils {
    public static final Pattern VARNAME = Pattern.compile("(\\?|\\$)?(?<varname>\\S*)");

    public static boolean isValidFirstCharForVarName(int ch) {
        return RiotChars.isPNChars_U((int)ch) || RiotChars.range((int)ch, (int)48, (int)57);
    }

    public static boolean isValidNonFirstCharForVarName(int ch) {
        return VarUtils.isValidFirstCharForVarName(ch) || ch == 183 || RiotChars.range((int)ch, (int)768, (int)879) || RiotChars.range((int)ch, (int)8255, (int)8256);
    }

    public static Map<Var, Var> parseVarMap(String str) {
        String[] entries;
        HashMap<Var, Var> result = new HashMap<Var, Var>();
        int l = str.length();
        int start = str.startsWith("{") ? 1 : 0;
        int end = str.endsWith("}") ? l - 1 : l;
        String sub = str.substring(start, end);
        for (String entry : entries = sub.split(",")) {
            String[] kv = entry.split("=", 2);
            Var k = VarUtils.parseVar(kv[0]);
            Var v = VarUtils.parseVar(kv[1]);
            result.put(k, v);
        }
        return result;
    }

    public static Var parseVar(String str) {
        String varName = str.trim();
        char c = varName.charAt(0);
        if (c != '?' && c != '$') {
            throw new RuntimeException("var name must start with '?' or '$'");
        }
        varName = varName.substring(1);
        Var result = Var.alloc((String)varName);
        return result;
    }

    public static Generator<Var> createVarGen(String prefix, Collection<Var> excludeVars) {
        prefix = prefix == null ? "v" : prefix;
        VarGeneratorBlacklist result = VarGeneratorBlacklist.create(prefix, excludeVars);
        return result;
    }

    public static List<String> getVarNames(Iterable<Var> vars) {
        ArrayList<String> result = new ArrayList<String>();
        for (Var var : vars) {
            result.add(var.getName());
        }
        return result;
    }

    public static List<Var> toList(Collection<String> varNames) {
        ArrayList<Var> result = new ArrayList<Var>(varNames.size());
        for (String varName : varNames) {
            Var var = Var.alloc((String)varName);
            result.add(var);
        }
        return result;
    }

    public static Set<Var> toSet(Collection<String> varNames) {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        for (String varName : varNames) {
            Var var = Var.alloc((String)varName);
            result.add(var);
        }
        return result;
    }

    public static List<String> map(Collection<String> varNames, Map<Var, Var> varMap) {
        ArrayList<String> result = new ArrayList<String>(varNames.size());
        for (String varName : varNames) {
            Var sourceVar = Var.alloc((String)varName);
            Var targetVar = varMap.get(sourceVar);
            if (targetVar == null) {
                targetVar = sourceVar;
            }
            String targetVarName = targetVar.getVarName();
            result.add(targetVarName);
        }
        return result;
    }

    public static Var applyNodeTransform(Var var, NodeTransform nodeTransform) {
        Var result = VarUtils.applyNodeTransform(var, nodeTransform, var);
        return result;
    }

    public static Var applyNodeTransform(Var var, NodeTransform nodeTransform, Var defaultVar) {
        Var tmp = (Var)nodeTransform.apply((Object)var);
        Var result = tmp == null ? defaultVar : tmp;
        return result;
    }

    public static Map<Var, Var> createDistinctVarMap(Collection<Var> vas, Collection<Var> vbs, boolean excludeSymmetry, Generator<Var> generator) {
        HashSet<Var> forbidden = new HashSet<Var>();
        forbidden.addAll(vas);
        forbidden.addAll(vbs);
        generator = VarGeneratorBlacklist.create(generator, forbidden);
        HashMap<Var, Var> result = new HashMap<Var, Var>();
        for (Var oldVar : vbs) {
            Var newVar = vas.contains(oldVar) ? (Var)generator.next() : oldVar;
            boolean isSame = oldVar.equals((Object)newVar);
            if (excludeSymmetry && isSame) continue;
            result.put(oldVar, newVar);
        }
        return result;
    }

    public static Map<Var, Var> createJoinVarMap(Collection<Var> sourceVars, Collection<Var> targetVars, List<Var> sourceJoinVars, List<Var> targetJoinVars, Generator<Var> generator) {
        if (sourceJoinVars.size() != targetJoinVars.size()) {
            throw new RuntimeException("Cannot join on different number of columns");
        }
        Map<Var, Var> result = VarUtils.createDistinctVarMap(sourceVars, targetVars, true, generator);
        for (int i = 0; i < sourceJoinVars.size(); ++i) {
            Var sourceJoinVar = sourceJoinVars.get(i);
            Var targetJoinVar = targetJoinVars.get(i);
            result.put(targetJoinVar, sourceJoinVar);
        }
        return result;
    }

    public static String safeVarName(String varName) {
        String result = VarUtils.safeIdentifier(varName, 95, VarUtils::isValidFirstCharForVarName, VarUtils::isValidNonFirstCharForVarName);
        return result;
    }

    public static String safeIdentifier(String varName, int replacement, IntPredicate isValidChar) {
        return VarUtils.safeIdentifier(varName, replacement, isValidChar, isValidChar);
    }

    public static String safeIdentifier(String varName, int replacement, IntPredicate isValidFirstChar, IntPredicate isValidNonFirstChar) {
        StringBuilder sb = new StringBuilder();
        int[] codePoints = varName.codePoints().toArray();
        if (codePoints.length > 0) {
            int before = codePoints[0];
            int after = isValidFirstChar.test(before) ? before : replacement;
            sb.appendCodePoint(after);
        }
        for (int i = 1; i < codePoints.length; ++i) {
            int before = codePoints[i];
            int after = isValidNonFirstChar.test(before) ? before : replacement;
            sb.appendCodePoint(after);
        }
        String result = sb.toString();
        return result.isEmpty() ? null : result;
    }

    public static Var safeVar(String varName) {
        String safeName = VarUtils.safeVarName(varName);
        return safeName == null ? null : Var.alloc((String)safeName);
    }
}

