/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.tuple.bridge.TupleBridge4;
import org.aksw.commons.tuple.finder.TupleFinder4;
import org.aksw.commons.tuple.finder.TupleFinder4Wrapper;
import org.aksw.commons.util.cache.CacheUtils;
import org.aksw.jenax.arq.util.tuple.IterUtils;
import org.aksw.jenax.arq.util.tuple.adapter.SparqlCxt;
import org.aksw.jenax.arq.util.tuple.adapter.TupleBridgeQuad;
import org.apache.jena.atlas.iterator.Iter;

public class TupleFinderSameAs<D, C>
extends TupleFinder4Wrapper<D, C, TupleFinder4<D, C>> {
    protected boolean logCacheStats = false;
    protected boolean allowDuplicates;
    protected SparqlCxt<C> sparqlCxt;
    protected Set<C> sameAsPredicates;
    protected boolean dropReflexive = true;
    protected BiPredicate<C, C> mayHaveSameAsLinks;

    public static <D, C> TupleFinder4<D, C> wrap(TupleFinder4<D, C> base, SparqlCxt<C> sparqlCxt, C sameAsPredicate) {
        return TupleFinderSameAs.wrap(base, sparqlCxt, Collections.singleton(sameAsPredicate), false);
    }

    public static <D, C> TupleFinder4<D, C> wrap(TupleFinder4<D, C> base, SparqlCxt<C> sparqlCxt, Set<C> sameAsPredicates) {
        return TupleFinderSameAs.wrap(base, sparqlCxt, sameAsPredicates, false);
    }

    public static <D, C> TupleFinder4<D, C> wrap(TupleFinder4<D, C> base, SparqlCxt<C> sparqlCxt, Set<C> sameAsPredicates, boolean allowDuplicates) {
        return TupleFinderSameAs.wrap(base, sparqlCxt, sameAsPredicates, allowDuplicates, null);
    }

    public static <D, C> TupleFinder4<D, C> wrap(TupleFinder4<D, C> base, SparqlCxt<C> sparqlCxt, Set<C> sameAsPredicates, boolean allowDuplicates, BiPredicate<C, C> mayHaveSameAsLinks) {
        return new TupleFinderSameAs<D, C>(base, sparqlCxt, sameAsPredicates, allowDuplicates, mayHaveSameAsLinks);
    }

    protected TupleFinderSameAs(TupleFinder4<D, C> base, SparqlCxt<C> sparqlCxt, Set<C> sameAsPredicates, boolean allowDuplicates, BiPredicate<C, C> mayHaveSameAsLinks) {
        super(base);
        this.sparqlCxt = sparqlCxt;
        this.sameAsPredicates = sameAsPredicates;
        this.mayHaveSameAsLinks = mayHaveSameAsLinks;
        this.allowDuplicates = allowDuplicates;
    }

    public Stream<D> find(C mg, C ms, C mp, C mo) {
        return new Worker(mg, ms, mp, mo).find();
    }

    private D computeLeastPhysicalQuad(D quad, List<C> sortedSubjects, List<C> sortedObjects) {
        Object result = null;
        C g = TupleBridgeQuad.getGraph(quad, this.getTupleBridge());
        C p = TupleBridgeQuad.getPredicate(quad, this.getTupleBridge());
        block0: for (C s : sortedSubjects) {
            for (C o : sortedObjects) {
                if (!((TupleFinder4)this.base).contains(g, s, p, o)) continue;
                result = this.getTupleBridge().build(g, s, p, o);
                break block0;
            }
        }
        if (result == null) {
            throw new IllegalStateException("Tuple [" + String.valueOf(quad) + "] was unexpectedly reported to not be contained in the backend");
        }
        return (D)result;
    }

    private List<C> resolveSameAsSorted(C g, C start) {
        List result = (List)this.resolveSameAs(g, start).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(result, this.sparqlCxt.comparator());
        return result;
    }

    private Iter<C> resolveSameAs(C g, C start) {
        Traverser traverser = Traverser.forGraph(n -> this.getDirectNodes(g, n));
        Iter result = Iter.iter(traverser.depthFirstPreOrder(start).iterator());
        return result;
    }

    private Set<C> getDirectNodes(C g, C start) {
        Set result = this.sparqlCxt.isLiteral(start) ? Collections.emptySet() : this.loadDirectNodes(g, start);
        return result;
    }

    private Set<C> loadDirectNodes(C g, C s) {
        Set result = this.findDirectTriples(g, s).toSet();
        return result;
    }

    private Iter<C> findDirectTriples(C g, C s) {
        return Iter.concat((Iter)Iter.iter(this.sameAsPredicates).flatMap(p -> this.findDirectNodes(g, s, p, true)), (Iter)Iter.iter(this.sameAsPredicates).flatMap(p -> this.findDirectNodes(g, s, p, false)));
    }

    private Iter<C> findDirectNodes(C g, C s, C p, boolean isForward) {
        Iter result = isForward ? IterUtils.iter(((TupleFinder4)this.base).find(g, s, p, this.sparqlCxt.any())).map(t -> TupleBridgeQuad.getObject(t, this.getTupleBridge())) : IterUtils.iter(((TupleFinder4)this.base).find(g, this.sparqlCxt.any(), p, s)).map(t -> TupleBridgeQuad.getSubject(t, this.getTupleBridge()));
        return result;
    }

    public TupleBridge4<D, C> getTupleBridge() {
        return ((TupleFinder4)this.base).getTupleBridge();
    }

    class Worker {
        protected C mg;
        protected C ms;
        protected C mp;
        protected C mo;
        protected Cache<Map.Entry<C, C>, List<C>> sameAsCache;
        protected Cache<D, D> leastQuadCache;

        public Worker(C mg, C ms, C mp, C mo) {
            this.sameAsCache = CacheUtils.recordStats((CacheBuilder)CacheBuilder.newBuilder(), (boolean)TupleFinderSameAs.this.logCacheStats).concurrencyLevel(1).maximumSize(10L).build();
            this.leastQuadCache = null;
            this.mg = mg;
            this.ms = ms;
            this.mp = mp;
            this.mo = mo;
        }

        public Stream<D> find() {
            List initialSubjects = this.resolveSameAsSortedCached(this.mg, this.ms);
            List initialObjects = this.resolveSameAsSortedCached(this.mg, this.mo);
            Iter result = Iter.iter(initialSubjects).flatMap(s -> Iter.iter((Collection)initialObjects).flatMap(o -> IterUtils.iter(((TupleFinder4)TupleFinderSameAs.this.base).find(this.mg, s, this.mp, o)).flatMap(t -> this.streamInferencesOnLeastQuad(t))));
            if (TupleFinderSameAs.this.logCacheStats) {
                result = Iter.onClose((Iterator)result, () -> {
                    System.out.println("SameAsCache: " + String.valueOf(CacheUtils.stats(this.sameAsCache)));
                    System.out.println("LeastQuadCache: " + String.valueOf(CacheUtils.stats(this.leastQuadCache)));
                });
            }
            return Iter.asStream((Iterator)result);
        }

        private Iterator<D> streamInferencesOnLeastQuad(D quad) {
            Iter result;
            Object g = TupleFinderSameAs.this.getTupleBridge().get(quad, 0);
            Object p = TupleFinderSameAs.this.getTupleBridge().get(quad, 2);
            List sortedSubjects = this.resolveSameAsSortedCached(g, TupleFinderSameAs.this.getTupleBridge().get(quad, 1));
            List sortedObjects = this.resolveSameAsSortedCached(g, TupleFinderSameAs.this.getTupleBridge().get(quad, 3));
            if (sortedSubjects.size() == 1 && sortedObjects.size() == 1) {
                result = Iter.of(quad);
            } else {
                boolean isLeastQuad;
                Object leastS = sortedSubjects.get(0);
                Object leastO = sortedObjects.get(0);
                Object leastInferrableQuad = TupleFinderSameAs.this.getTupleBridge().build(g, leastS, p, leastO);
                if (!TupleFinderSameAs.this.allowDuplicates) {
                    Object leastPhysicalQuad = CacheUtils.get(this.leastQuadCache, (Object)leastInferrableQuad, () -> TupleFinderSameAs.this.computeLeastPhysicalQuad(leastInferrableQuad, sortedSubjects, sortedObjects));
                    isLeastQuad = quad.equals(leastPhysicalQuad);
                } else {
                    isLeastQuad = true;
                }
                List ss = TupleFinderSameAs.this.sparqlCxt.isConcrete(this.ms) ? Collections.singletonList(this.ms) : sortedSubjects;
                List oo = TupleFinderSameAs.this.sparqlCxt.isConcrete(this.mo) ? Collections.singletonList(this.mo) : sortedObjects;
                result = isLeastQuad ? Iter.iter(ss).flatMap(s -> Iter.iter((Collection)oo).filter(o -> !TupleFinderSameAs.this.dropReflexive || !TupleFinderSameAs.this.sameAsPredicates.contains(p) || !Objects.equals(s, o)).map(o -> TupleFinderSameAs.this.getTupleBridge().build(g, s, p, o))) : Iter.empty();
            }
            return result;
        }

        private List<C> resolveSameAsSortedCached(C g, C start) {
            List result;
            if (!TupleFinderSameAs.this.sparqlCxt.isConcrete(g) || !TupleFinderSameAs.this.sparqlCxt.isConcrete(start) || TupleFinderSameAs.this.sparqlCxt.isLiteral(start)) {
                result = Collections.singletonList(start);
            } else {
                Map.Entry startKey = Map.entry(g, start);
                result = (List)CacheUtils.getIfPresent(this.sameAsCache, startKey);
                if (result == null && TupleFinderSameAs.this.mayHaveSameAsLinks != null && !TupleFinderSameAs.this.mayHaveSameAsLinks.test(g, start)) {
                    result = Collections.singletonList(start);
                }
                if (result == null) {
                    boolean[] wasComputed = new boolean[]{false};
                    result = (List)CacheUtils.get(this.sameAsCache, startKey, () -> {
                        wasComputed[0] = true;
                        return TupleFinderSameAs.this.resolveSameAsSorted(g, start);
                    });
                    boolean updateClosureForAllMembers = false;
                    if (updateClosureForAllMembers && wasComputed[0]) {
                        for (Object node : result) {
                            if (node.equals(start)) continue;
                            this.sameAsCache.put(Map.entry(g, node), (Object)result);
                        }
                        this.sameAsCache.put(startKey, (Object)result);
                    }
                }
            }
            return result;
        }
    }
}

