/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import com.google.common.collect.Streams;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.io.NTripleUtils;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.arq.util.triple.GraphWrapperTransform;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphUtils {
    public static Stream<Node> streamNodes(Graph graph) {
        return GraphUtils.stream(graph).flatMap(TripleUtils::streamNodes);
    }

    public static Iterator<Node> iterateNodes(Graph graph) {
        return GraphUtils.streamNodes(graph).iterator();
    }

    public static Graph optimizePrefixes(Graph graph) {
        PrefixMapping pm = graph.getPrefixMapping();
        PrefixMappingImpl usedPrefixes = new PrefixMappingImpl();
        try (Stream<Node> nodeStream = GraphUtils.streamNodes(graph);){
            PrefixUtils.usedPrefixes(pm, nodeStream, (PrefixMapping)usedPrefixes);
        }
        pm.clearNsPrefixMap();
        pm.setNsPrefixes((PrefixMapping)usedPrefixes);
        return graph;
    }

    public static Stream<Triple> stream(Graph graph) {
        ExtendedIterator it = graph.find();
        return (Stream)Streams.stream((Iterator)it).onClose(() -> ((ExtendedIterator)it).close());
    }

    public static Stream<Triple> createTripleStream(String resourceName) {
        TypedInputStream in = RDFDataMgr.open((String)resourceName);
        Lang lang = RDFDataMgr.determineLang((String)resourceName, (String)in.getContentType(), (Lang)Lang.TURTLE);
        Iterator it = RDFDataMgr.createIteratorTriples((InputStream)in, (Lang)lang, (String)"http://example.org/");
        return Streams.stream((Iterator)it);
    }

    public static Graph toMemGraph(Iterable<Triple> triples) {
        Graph result = GraphFactory.createGraphMem();
        triples.forEach(arg_0 -> ((Graph)result).add(arg_0));
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Graph graph) {
        Map<Node, Graph> result;
        try (ExtendedIterator it = graph.find(Node.ANY, Node.ANY, Node.ANY);){
            result = GraphUtils.indexBySubject((Iterator<Triple>)it);
        }
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Iterable<Triple> triples) {
        Map<Node, Graph> result = GraphUtils.indexBySubject(triples.iterator());
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Iterator<Triple> it) {
        HashMap<Node, Graph> result = new HashMap<Node, Graph>();
        while (it.hasNext()) {
            Triple triple = it.next();
            Node s = triple.getSubject();
            Graph graph = (Graph)result.get(s);
            if (graph == null) {
                graph = GraphFactory.createGraphMem();
                result.put(s, graph);
            }
            graph.add(triple);
        }
        return result;
    }

    public static Triple fixTripleWithGraphInObject(Triple t) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<x:s> <x:p> ");
            sb.append(NodeFmtLib.strNT((Node)t.getObject()));
            sb.append(" .");
            String str = sb.toString();
            Quad q = NTripleUtils.parseNQuadsString(str);
            Triple r = Triple.create((Node)t.getSubject(), (Node)t.getPredicate(), (Node)q.getObject());
            return r;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Graph wrapGraphWithNQuadsFix(Graph base) {
        return new GraphWrapperTransform(base, it -> it.mapWith(GraphUtils::fixTripleWithGraphInObject).filterKeep(Objects::nonNull));
    }

    public static Graph wrapWithValidation(Graph base) {
        return new GraphWrapperTransform(base, it -> it.filterKeep(TripleUtils::isValid));
    }
}

