/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.quad;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.resultset.ResultSetCompare;

public class DatasetCmp {
    public static boolean isIsomorphic(Dataset expected, Dataset actual, boolean compareByValue, PrintStream out, Lang lang) {
        boolean result;
        String everything = "SELECT ?g ?s ?p ?o { { GRAPH ?g { ?s ?p ?o } } UNION { ?s ?p ?o } }";
        try (QueryExecution qea = QueryExecutionFactory.create((String)everything, (Dataset)expected);
             QueryExecution qeb = QueryExecutionFactory.create((String)everything, (Dataset)actual);){
            ResultSetRewindable rsa = ResultSetFactory.copyResults((ResultSet)qea.execSelect());
            ResultSetRewindable rsb = ResultSetFactory.copyResults((ResultSet)qeb.execSelect());
            boolean bl = result = compareByValue ? ResultSetCompare.equalsByValue((ResultSet)rsa, (ResultSet)rsb) : ResultSetCompare.equalsByTerm((ResultSet)rsa, (ResultSet)rsb);
            if (!result) {
                rsa.reset();
                rsb.reset();
                out.println("Expected:");
                ResultSetMgr.write((OutputStream)out, (ResultSet)rsa, (Lang)lang);
                out.println("Actual:");
                ResultSetMgr.write((OutputStream)out, (ResultSet)rsb, (Lang)lang);
            }
        }
        return result;
    }

    public static Report assessIsIsomorphicByGraph(Dataset expected, Dataset actual) {
        return DatasetCmp.assessIsIsomorphicByGraph(expected.asDatasetGraph(), actual.asDatasetGraph());
    }

    public static Report assessIsIsomorphicByGraph(DatasetGraph expected, DatasetGraph actual) {
        Report report = new Report();
        if (!expected.getDefaultGraph().isIsomorphicWith(actual.getDefaultGraph())) {
            report.nonIsomorphicGraphs.add(Quad.defaultGraphIRI);
        }
        LinkedHashSet allNodes = new LinkedHashSet();
        expected.listGraphNodes().forEachRemaining(allNodes::add);
        actual.listGraphNodes().forEachRemaining(allNodes::add);
        for (Node g : allNodes) {
            if (!expected.containsGraph(g)) {
                report.missingGraphsFirst().add(g);
            }
            if (!actual.containsGraph(g)) {
                report.missingGraphsSecond().add(g);
            }
            Graph g1 = expected.getGraph(g);
            Graph g2 = actual.getGraph(g);
            if (g1.size() == g2.size()) continue;
            report.nonIsomorphicGraphs().add(g);
        }
        return report;
    }

    public record Report(Set<Node> nonIsomorphicGraphs, Set<Node> missingGraphsFirst, Set<Node> missingGraphsSecond) {
        public Report() {
            this(new LinkedHashSet<Node>(), new LinkedHashSet<Node>(), new LinkedHashSet<Node>());
        }

        public boolean isIsomorphic() {
            return this.missingGraphsFirst.isEmpty() && this.missingGraphsSecond.isEmpty() && this.nonIsomorphicGraphs.isEmpty();
        }

        @Override
        public String toString() {
            return "Missing graphs first : " + String.valueOf(this.missingGraphsFirst) + "\nMissing graphs second: " + String.valueOf(this.missingGraphsSecond) + "\nNon-isomorphic graphs: " + String.valueOf(this.nonIsomorphicGraphs);
        }
    }
}

