/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.prefix;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Trie;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMapBase;

public class PrefixMapTrie
extends PrefixMapBase {
    private Map<String, String> prefixToIri = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, String> prefixToIriView = Collections.unmodifiableMap(this.prefixToIri);
    private Trie<String> iriToPrefix = new Trie();
    private Cache<String, Optional<String>> longestMatchCache;

    public PrefixMapTrie() {
        this(1000L);
    }

    public PrefixMapTrie(long longestMatchCacheSize) {
        this.longestMatchCache = CacheBuilder.newBuilder().maximumSize(longestMatchCacheSize).build();
    }

    public Optional<String> findMapping(String iri, boolean partial) {
        Optional prefix;
        try {
            prefix = partial ? (Optional)this.longestMatchCache.get((Object)iri, () -> Optional.ofNullable((String)this.iriToPrefix.longestMatch(iri))) : Optional.ofNullable((String)this.iriToPrefix.get(iri));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected failure during cache lookup", e);
        }
        return prefix;
    }

    public void add(String prefix, String iri) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(iri);
        String canonicalPrefix = PrefixLib.canonicalPrefix((String)prefix);
        this.longestMatchCache.invalidateAll();
        String oldIri = this.prefixToIri.get(canonicalPrefix);
        if (oldIri != null) {
            this.iriToPrefix.remove(oldIri);
        }
        this.prefixToIri.put(canonicalPrefix, iri);
        this.iriToPrefix.add(iri, (Object)canonicalPrefix);
    }

    public void delete(String prefix) {
        Objects.requireNonNull(prefix);
        String canonicalPrefix = PrefixLib.canonicalPrefix((String)prefix);
        this.longestMatchCache.invalidateAll();
        String iriForPrefix = this.prefixToIri.get(canonicalPrefix);
        if (iriForPrefix != null) {
            this.prefixToIri.remove(canonicalPrefix);
            String prefixForIri = (String)this.iriToPrefix.get(iriForPrefix);
            if (canonicalPrefix.equals(prefixForIri)) {
                this.iriToPrefix.remove(prefixForIri);
            }
        }
    }

    public Pair<String, String> abbrev(String iriStr) {
        String localName;
        String prefix;
        Objects.requireNonNull(iriStr);
        Pair result = null;
        String iriForPrefix = null;
        String candidate = PrefixMapTrie.getPossibleKey(iriStr);
        if (candidate != null) {
            iriForPrefix = (String)this.iriToPrefix.get(candidate);
        }
        if (iriForPrefix == null && (prefix = (String)this.findMapping(iriStr, true).orElse(null)) != null) {
            iriForPrefix = this.prefixToIri.get(prefix);
        }
        if (iriForPrefix != null && PrefixLib.isSafeLocalPart((String)(localName = iriStr.substring(iriForPrefix.length())))) {
            result = Pair.create((Object)iriForPrefix, (Object)localName);
        }
        return result;
    }

    public String abbreviate(String iriStr) {
        Objects.requireNonNull(iriStr);
        String result = null;
        Pair<String, String> prefixAndLocalName = this.abbrev(iriStr);
        if (prefixAndLocalName != null) {
            String prefix = (String)prefixAndLocalName.getLeft();
            String ln = (String)prefixAndLocalName.getRight();
            if (this.strSafeFor(ln, ':')) {
                result = prefix + ":" + ln;
            }
        }
        return result;
    }

    public String get(String prefix) {
        Objects.requireNonNull(prefix);
        return this.prefixToIri.get(prefix);
    }

    public Map<String, String> getMapping() {
        return this.prefixToIriView;
    }

    public void clear() {
        this.longestMatchCache.invalidateAll();
        this.prefixToIri.clear();
        this.iriToPrefix.clear();
    }

    public boolean isEmpty() {
        return this.prefixToIri.isEmpty();
    }

    public int size() {
        return this.prefixToIri.size();
    }

    public boolean containsPrefix(String prefix) {
        Objects.requireNonNull(prefix);
        String canonicalPrefix = PrefixLib.canonicalPrefix((String)prefix);
        return this.prefixToIri.containsKey(canonicalPrefix);
    }

    protected static String getPossibleKey(String iriString) {
        char c;
        int i;
        int n = iriString.length();
        for (i = n - 1; i >= 0 && (c = iriString.charAt(i)) != '#' && c != '/'; --i) {
        }
        String result = i >= 0 ? iriString.substring(0, i + 1) : null;
        return result;
    }
}

