/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class NodeTransformLib2 {
    public static Expr transform(NodeTransform nodeTransform, Expr expr) {
        NodeTransformExpr exprTransform = new NodeTransformExpr(nodeTransform);
        Expr result = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
        return result;
    }

    public static NodeTransform wrapWithNullAsIdentity(NodeTransform xform) {
        return x -> {
            Node tmp = (Node)xform.apply(x);
            Node r = tmp == null ? x : tmp;
            return r;
        };
    }

    public static NodeTransform substPrefix(Map<String, String> map, String separator) {
        return node -> {
            Node r = node;
            if (node.isURI()) {
                String oldStr = node.getURI();
                String[] parts = oldStr.split(separator, 2);
                String oldPrefix = parts[0];
                String newPrefix = (String)map.get(oldPrefix);
                String newStr = newPrefix != null ? newPrefix + (String)(parts.length > 1 ? separator + parts[1] : "") : oldStr;
                r = newStr == oldStr ? node : NodeFactory.createURI((String)newStr);
            }
            return r;
        };
    }

    public static Binding transformValues(Binding b, NodeTransform transform) {
        BindingBuilder bb = BindingBuilder.create();
        List vars = Iter.toList((Iterator)b.vars());
        for (Var v : vars) {
            Node before = b.get(v);
            Node after = (Node)transform.apply((Object)before);
            bb.add(v, after);
        }
        Binding result = bb.build();
        return result;
    }

    public static Graph copyWithNodeTransform(NodeTransform nodeTransform, Graph graph) {
        Graph result = GraphFactory.createDefaultGraph();
        graph.find().mapWith(t -> NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)t)).forEachRemaining(arg_0 -> ((Graph)result).add(arg_0));
        return result;
    }

    public static Graph copyWithNodeTransform(NodeTransform nodeTransform, Graph in, Graph out) {
        if (in == out) {
            NodeTransformLib2.applyNodeTransform(nodeTransform, in);
        } else {
            in.find().mapWith(t -> NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)t)).forEachRemaining(arg_0 -> ((Graph)out).add(arg_0));
        }
        return out;
    }

    public static SortCondition transform(NodeTransform nodeTransform, SortCondition sortCondition) {
        Expr before = sortCondition.getExpression();
        Expr after = NodeTransformLib2.transform(nodeTransform, before);
        int dir = sortCondition.getDirection();
        SortCondition result = new SortCondition(after, dir);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Graph applyNodeTransform(NodeTransform nodeTransform, Graph graph) {
        ArrayList<Triple> inserts = new ArrayList<Triple>();
        ArrayList<Triple> deletions = new ArrayList<Triple>();
        try (ExtendedIterator it = graph.find();){
            while (it.hasNext()) {
                Triple before = (Triple)it.next();
                Triple after = NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)before);
                if (after.equals((Object)before)) continue;
                deletions.add(before);
                inserts.add(after);
            }
        }
        for (Triple t : deletions) {
            graph.delete(t);
        }
        for (Triple t : inserts) {
            graph.add(t);
        }
        return graph;
    }

    public static RDFNode applyNodeTransform(NodeTransform nodeTransform, RDFNode rdfNode) {
        Model model = rdfNode.getModel();
        NodeTransformLib2.applyNodeTransform(nodeTransform, model);
        Node beforeNode = rdfNode.asNode();
        Node tmp = (Node)nodeTransform.apply((Object)beforeNode);
        Node afterNode = tmp == null ? beforeNode : tmp;
        RDFNode result = model.asRDFNode(afterNode);
        return result;
    }

    public static RDFNode copyWithNodeTransform(NodeTransform nodeTransform, RDFNode rdfNode) {
        Model beforeModel = rdfNode.getModel();
        Model afterModel = NodeTransformLib2.copyWithNodeTransform(nodeTransform, beforeModel);
        Node beforeNode = rdfNode.asNode();
        Node tmp = (Node)nodeTransform.apply((Object)beforeNode);
        Node afterNode = tmp == null ? beforeNode : tmp;
        RDFNode result = afterModel.asRDFNode(afterNode);
        return result;
    }

    public static Model applyNodeTransform(NodeTransform nodeTransform, Model model) {
        Graph oldGraph = model.getGraph();
        NodeTransformLib2.applyNodeTransform(nodeTransform, oldGraph);
        return model;
    }

    public static Model copyWithNodeTransform(NodeTransform nodeTransform, Model model) {
        Graph oldGraph = model.getGraph();
        Graph newGraph = NodeTransformLib2.copyWithNodeTransform(nodeTransform, oldGraph);
        Model result = ModelFactory.createModelForGraph((Graph)newGraph);
        return result;
    }

    public static DatasetGraph applyNodeTransform(NodeTransform nodeTransform, DatasetGraph dg) {
        return NodeTransformLib2.applyQuadTransform(q -> NodeTransformLib.transform((NodeTransform)nodeTransform, (Quad)q), dg);
    }

    public static DatasetGraph applyQuadTransform(Function<? super Quad, ? extends Quad> quadTransform, DatasetGraph dg) {
        ArrayList quads = new ArrayList();
        WrappedIterator.create((Iterator)dg.find()).mapWith(quadTransform::apply).forEachRemaining(quads::add);
        dg.clear();
        for (Quad quad : quads) {
            dg.add(quad);
        }
        return dg;
    }

    public static RowSet applyNodeTransform(NodeTransform nodeTransform, RowSet decoratee) {
        ExtendedIterator it = WrappedIterator.create((Iterator)decoratee).mapWith(b -> NodeTransformLib.transform((Binding)b, (NodeTransform)nodeTransform));
        return new RowSet(){
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ RowSet val$decoratee;
            {
                this.val$it = iterator;
                this.val$decoratee = rowSet;
            }

            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            public Binding next() {
                return (Binding)this.val$it.next();
            }

            public List<Var> getResultVars() {
                return this.val$decoratee.getResultVars();
            }

            public long getRowNumber() {
                return this.val$decoratee.getRowNumber();
            }

            public void close() {
                this.val$decoratee.close();
            }
        };
    }

    public static DatasetGraph copyWithNodeTransform(NodeTransform nodeTransform, DatasetGraph graph) {
        DatasetGraph result = DatasetGraphFactory.create();
        NodeTransformLib2.copyWithNodeTransform(nodeTransform, graph, result);
        return result;
    }

    public static DatasetGraph copyWithNodeTransform(NodeTransform nodeTransform, DatasetGraph in, DatasetGraph out) {
        if (in == out) {
            NodeTransformLib2.applyNodeTransform(nodeTransform, in);
        } else {
            WrappedIterator.create((Iterator)in.find()).mapWith(t -> NodeTransformLib.transform((NodeTransform)nodeTransform, (Quad)t)).forEachRemaining(arg_0 -> ((DatasetGraph)out).add(arg_0));
        }
        return out;
    }

    public static Dataset applyNodeTransform(NodeTransform nodeTransform, Dataset dataset) {
        DatasetGraph dg = dataset.asDatasetGraph();
        NodeTransformLib2.applyNodeTransform(nodeTransform, dg);
        return dataset;
    }

    public static Dataset copyWithNodeTransform(NodeTransform nodeTransform, Dataset graph) {
        Dataset result = DatasetFactory.create();
        NodeTransformLib2.copyWithNodeTransform(nodeTransform, graph, result);
        return result;
    }

    public static Dataset copyWithNodeTransform(NodeTransform nodeTransform, Dataset in, Dataset out) {
        if (in == out) {
            NodeTransformLib2.applyNodeTransform(nodeTransform, in);
        } else {
            NodeTransformLib2.copyWithNodeTransform(nodeTransform, in.asDatasetGraph(), out.asDatasetGraph());
        }
        return out;
    }

    public static <T> ExtendedIterator<T> map(Iterator<T> it, Function<? super T, ? extends T> xform) {
        ExtendedIterator result = WrappedIterator.create(it).mapWith(x -> xform.apply(x));
        return result;
    }

    public static Expr addBnodeCheckAndTransform(Expr bnodeLabelTransform, Var v) {
        ExprVar ev = new ExprVar(v);
        E_Function bnodeLabelOf = new E_Function("http://jena.apache.org/ARQ/function#bnode", new ExprList((Expr)ev));
        Expr e2 = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(v, (Expr)bnodeLabelOf), (Expr)bnodeLabelTransform);
        E_Conditional result = new E_Conditional((Expr)new E_IsBlank((Expr)ev), (Expr)new E_IRI(e2), (Expr)ev);
        return result;
    }

    public static NodeTransform createBnodeLabelTransform(Expr bnodeLabelTransform, Var v) {
        Expr conditionalExpr = NodeTransformLib2.addBnodeCheckAndTransform(bnodeLabelTransform, v);
        NodeTransform result = NodeTransformLib2.createNodeTransform(conditionalExpr, v);
        return result;
    }

    public static NodeTransform createNodeTransform(Expr expr, Var v) {
        return x -> {
            Binding b = BindingFactory.binding((Var)v, (Node)x);
            NodeValue nv = ExprUtils.eval((Expr)expr, (Binding)b);
            Node r = nv.asNode();
            return r;
        };
    }
}

