/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.dataset;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NodeUtils;

public abstract class DatasetGraphWrapperFindBase
extends DatasetGraphWrapper {
    protected DatasetGraphWrapperFindBase(DatasetGraph dsg) {
        super(dsg);
    }

    protected abstract Iterator<Quad> actionFind(boolean var1, Node var2, Node var3, Node var4, Node var5);

    protected Iterator<Quad> delegateFind(boolean ng, Node g, Node s, Node p, Node o) {
        return ng ? this.getR().findNG(g, s, p, o) : this.getR().find(g, s, p, o);
    }

    public Iterator<Quad> find(boolean ng, Node g, Node s, Node p, Node o) {
        Node gg = NodeUtils.nullToAny((Node)g);
        Node ss = NodeUtils.nullToAny((Node)s);
        Node pp = NodeUtils.nullToAny((Node)p);
        Node oo = NodeUtils.nullToAny((Node)o);
        return this.actionFind(ng, gg, ss, pp, oo);
    }

    public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return this.find(false, g, s, p, o);
    }

    public Iterator<Quad> find(Quad quad) {
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return this.find(true, g, s, p, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Node g, Node s, Node p, Node o) {
        boolean result;
        Iterator<Quad> it = this.find(g, s, p, o);
        try {
            result = it.hasNext();
        }
        finally {
            Iter.close(it);
        }
        return result;
    }

    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public Graph getUnionGraph() {
        return GraphView.createUnionGraph((DatasetGraph)this);
    }
}

