/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.binding;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.aksw.jenax.arq.util.binding.QuerySolutionWithEquals;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;

public class ResultSetUtils {
    public static Table resultSetToTable(ResultSet rs) {
        List vars = Var.varList((Collection)rs.getResultVars());
        Table result = TableFactory.create((List)vars);
        while (rs.hasNext()) {
            Binding b = BindingFactory.copy((Binding)rs.nextBinding());
            result.addBinding(b);
        }
        return result;
    }

    public static List<Var> getVars(ResultSet rs) {
        List<Var> result = VarUtils.toList(rs.getResultVars());
        return result;
    }

    public static Node getNextNode(ResultSet rs, Var v) {
        Node result = null;
        if (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            result = binding.get(v);
        }
        return result;
    }

    public static Optional<Node> tryGetNextNode(ResultSet rs, Var v) {
        Node node = ResultSetUtils.getNextNode(rs, v);
        Optional<Node> result = Optional.ofNullable(node);
        return result;
    }

    public static RDFNode getNextRDFNode(ResultSet rs, Var v) {
        RDFNode result = null;
        if (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String varName = v.getName();
            result = qs.get(varName);
        }
        return result;
    }

    public static Optional<RDFNode> tryGetNextRDFNode(ResultSet rs, Var v) {
        RDFNode node = ResultSetUtils.getNextRDFNode(rs, v);
        Optional<RDFNode> result = Optional.ofNullable(node);
        return result;
    }

    public static Integer resultSetToInt(ResultSet rs, Var v) {
        Integer result = null;
        if (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(v);
            NodeValue nv = NodeValue.makeNode((Node)node);
            result = nv.getInteger().intValue();
        }
        return result;
    }

    public static List<Binding> resultSetToList(ResultSet rs) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            result.add(binding);
        }
        return result;
    }

    public static List<Node> resultSetToList(ResultSet rs, Var v) {
        ArrayList<Node> result = new ArrayList<Node>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(v);
            result.add(node);
        }
        return result;
    }

    public static ResultSet create(List<String> varNames, Iterator<Binding> bindingIt) {
        QueryIterator queryIter = QueryIterPlainWrapper.create(bindingIt);
        ResultSet result = ResultSetFactory.create((QueryIterator)queryIter, varNames);
        return result;
    }

    public static ResultSet createUsingVars(Iterable<Var> vars, Iterator<Binding> bindingIt) {
        List<String> varNames = VarUtils.getVarNames(vars);
        ResultSet result = ResultSetUtils.create(varNames, bindingIt);
        return result;
    }

    public static Multiset<QuerySolution> toMultisetQs(ResultSet rs) {
        HashMultiset result = HashMultiset.create();
        while (rs.hasNext()) {
            QuerySolution original = rs.next();
            QuerySolutionWithEquals wrapped = new QuerySolutionWithEquals(original);
            result.add((Object)wrapped);
        }
        return result;
    }

    public static Multiset<Binding> toMultiset(ResultSet rs) {
        HashMultiset result = HashMultiset.create();
        while (rs.hasNext()) {
            Binding original;
            Binding wrapped = original = rs.nextBinding();
            result.add((Object)wrapped);
        }
        return result;
    }
}

