/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.adapter;

import java.util.Collection;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;

public class TupleBridgeBinding
implements TupleBridge<Binding, Node> {
    private final Var[] vars;

    protected TupleBridgeBinding(Var[] vars) {
        this.vars = vars;
    }

    public int getDimension() {
        return this.vars.length;
    }

    public static TupleBridgeBinding of(Var ... vars) {
        return new TupleBridgeBinding(vars);
    }

    public static TupleBridgeBinding of(Collection<Var> vars) {
        return TupleBridgeBinding.of(vars.toArray(new Var[0]));
    }

    public Node get(Binding tupleLike, int componentIdx) {
        Var var = this.vars[componentIdx];
        Node result = tupleLike.get(var);
        return result;
    }

    public <T> Binding build(T obj, TupleAccessor<? super T, ? extends Node> accessor) {
        BindingBuilder builder = BindingFactory.builder();
        for (int i = 0; i < this.getDimension(); ++i) {
            Var var = this.vars[i];
            Node node = (Node)accessor.get(obj, i);
            builder.add(var, node);
        }
        Binding result = builder.build();
        return result;
    }
}

