/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.exec.query;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.exec.query.StageGeneratorStream;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.G;

public class StageGeneratorStreamGeneric
implements StageGeneratorStream {
    private static final ReorderTransformation reorderFixed = ReorderLib.fixed();

    @Override
    public Stream<Binding> execute(BasicPattern pattern, Stream<Binding> input, ExecutionContext execCxt) {
        if (input == null) {
            Log.error((Object)this, (String)("Null input to " + Lib.classShortName(this.getClass())));
        }
        ReorderTransformation reorder = reorderFixed;
        return this.execute(pattern, reorder, input, execCxt);
    }

    protected Stream<Binding> execute(BasicPattern pattern, ReorderTransformation reorder, Stream<Binding> input, ExecutionContext execCxt) {
        Explain.explain((BasicPattern)pattern, (Context)execCxt.getContext());
        List triples = pattern.getList();
        Stream<Object> chain = input;
        for (Triple triple : triples) {
            chain = chain.flatMap(b -> this.execute(input, execCxt.getActiveGraph(), triple, null, execCxt));
        }
        Explain.explain((String)"Reorder/generic", (BasicPattern)pattern, (Context)execCxt.getContext());
        return chain;
    }

    public Stream<Binding> execute(Stream<Binding> input, Graph graph, Triple pattern, Predicate<Triple> filter, ExecutionContext execCxt) {
        return StageGeneratorStreamGeneric.accessTriple(input, graph, pattern, filter, execCxt);
    }

    public static Stream<Binding> accessTriple(Stream<Binding> input, Graph graph, Triple pattern, Predicate<Triple> filter, ExecutionContext execCxt) {
        return input.flatMap(b -> StageGeneratorStreamGeneric.accessTriple(b, graph, pattern, filter, execCxt));
    }

    private static Stream<Binding> accessTriple(Binding binding, Graph graph, Triple pattern, Predicate<Triple> filter, ExecutionContext execCxt) {
        Node s = StageGeneratorStreamGeneric.substituteFlat(pattern.getSubject(), binding);
        Node p = StageGeneratorStreamGeneric.substituteFlat(pattern.getPredicate(), binding);
        Node o = StageGeneratorStreamGeneric.substituteFlat(pattern.getObject(), binding);
        Node s2 = NodeUtils.nullOrVarToAny(s);
        Node p2 = NodeUtils.nullOrVarToAny(p);
        Node o2 = NodeUtils.nullOrVarToAny(o);
        Stream<Triple> graphIter = StageGeneratorStreamGeneric.findByLang(graph, s2, p2, o2);
        Stream<Binding> iter = graphIter.map(r -> StageGeneratorStreamGeneric.mapper(Binding.builder((Binding)binding), s, p, o, r)).filter(Objects::nonNull);
        return iter;
    }

    private static Node substituteFlat(Node n, Binding binding) {
        return Var.lookup(arg_0 -> ((Binding)binding).get(arg_0), (Node)n);
    }

    public static Stream<Triple> findByLang(Graph g, Node s, Node p, Node o) {
        if (G.isNullOrAny((Node)o)) {
            return g.stream(s, p, o);
        }
        if (!G.hasLang((Node)o)) {
            return g.stream(s, p, o);
        }
        Stream<Triple> iter = g.stream(s, p, Node.ANY).filter(triple -> G.sameTermMatch((Node)o, (Node)triple.getObject()));
        return iter;
    }

    private static Binding mapper(BindingBuilder resultsBuilder, Node s, Node p, Node o, Triple r) {
        resultsBuilder.reset();
        if (!StageGeneratorStreamGeneric.insert(resultsBuilder, s, r.getSubject())) {
            return null;
        }
        if (!StageGeneratorStreamGeneric.insert(resultsBuilder, p, r.getPredicate())) {
            return null;
        }
        if (!StageGeneratorStreamGeneric.insert(resultsBuilder, o, r.getObject())) {
            return null;
        }
        return resultsBuilder.build();
    }

    private static boolean insert(BindingBuilder results, Node patternNode, Node dataNode) {
        if (!Var.isVar((Node)patternNode)) {
            return true;
        }
        Var v = Var.alloc((Node)patternNode);
        Node x = results.get(v);
        if (x != null) {
            return SolverLib.sameTermAs((Node)dataNode, (Node)x);
        }
        results.add(v, dataNode);
        return true;
    }
}

