/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.dataset;

import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;

public class DynamicDatasetUtils {
    public static DatasetGraph unwrap(DatasetGraph dg) {
        DynamicDatasets.DynamicDatasetGraph ddg;
        DatasetGraph result = dg;
        if (dg instanceof DynamicDatasets.DynamicDatasetGraph && DynamicDatasetUtils.isUnwrappable(ddg = (DynamicDatasets.DynamicDatasetGraph)dg)) {
            result = ddg.getOriginal();
        }
        return result;
    }

    public static boolean isUnwrappable(DynamicDatasets.DynamicDatasetGraph ddg) {
        boolean result = ddg.getOriginal() != null && ddg.getOriginalDefaultGraphs() != null && ddg.getOriginalNamedGraphs() != null;
        return result;
    }

    public static DynamicDatasets.DynamicDatasetGraph asUnwrappableDynamicDatasetOrNull(DatasetGraph dg) {
        DynamicDatasets.DynamicDatasetGraph ddg;
        DynamicDatasets.DynamicDatasetGraph result = null;
        if (dg instanceof DynamicDatasets.DynamicDatasetGraph && DynamicDatasetUtils.isUnwrappable(ddg = (DynamicDatasets.DynamicDatasetGraph)dg)) {
            result = ddg;
        }
        return result;
    }

    public static DatasetGraph unwrapOriginal(DatasetGraph dg) {
        DynamicDatasets.DynamicDatasetGraph ddg;
        DatasetGraph result = dg;
        if (dg instanceof DynamicDatasets.DynamicDatasetGraph && DynamicDatasetUtils.isUnwrappable(ddg = (DynamicDatasets.DynamicDatasetGraph)dg)) {
            result = ddg.getOriginal();
        }
        return result;
    }

    public static Pair<Query, DatasetGraph> unwrap(Query query, DatasetGraph dataset) {
        DynamicDatasets.DynamicDatasetGraph ddg;
        Pair result = null;
        if (dataset instanceof DynamicDatasets.DynamicDatasetGraph && DynamicDatasetUtils.isUnwrappable(ddg = (DynamicDatasets.DynamicDatasetGraph)dataset)) {
            query.getGraphURIs().clear();
            query.getNamedGraphURIs().clear();
            ddg.getOriginalDefaultGraphs().forEach(n -> query.getGraphURIs().add(n.getURI()));
            ddg.getOriginalNamedGraphs().forEach(n -> query.getNamedGraphURIs().add(n.getURI()));
            result = Pair.create((Object)query, (Object)ddg.getOriginal());
        }
        if (result == null) {
            result = Pair.create((Object)query, (Object)dataset);
        }
        return result;
    }
}

