/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.resultset;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.jenax.arq.util.tuple.resultset.ResultStreamer;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;

public class ResultStreamerFromComponent<D, C>
implements ResultStreamer<D, C, Tuple<C>> {
    protected Supplier<Stream<C>> componentStreamer;
    protected TupleBridge<D, C> domainAccessor;

    public ResultStreamerFromComponent(Supplier<Stream<C>> componentStreamer, TupleBridge<D, C> domainAccessor) {
        this.componentStreamer = componentStreamer;
        this.domainAccessor = domainAccessor;
    }

    @Override
    public Stream<D> streamAsDomainObject() {
        int domainDimension = this.domainAccessor.getDimension();
        if (domainDimension != 1) {
            throw new UnsupportedOperationException("Cannot convert component into a domain object of dimension != 1; has" + domainDimension);
        }
        return this.streamAsComponent().map(component -> this.domainAccessor.build(component, (x, idx) -> x));
    }

    @Override
    public Stream<C> streamAsComponent() {
        return this.componentStreamer.get();
    }

    @Override
    public Stream<Tuple<C>> streamAsTuple() {
        return this.streamAsComponent().map(TupleFactory::create1);
    }

    @Override
    public ResultStreamer.BackingType getBackingType() {
        return ResultStreamer.BackingType.COMPONENT;
    }
}

