/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple.adapter;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aksw.commons.tuple.bridge.TupleBridge4;
import org.aksw.commons.tuple.finder.TupleFinder4;
import org.aksw.jenax.arq.util.tuple.adapter.TupleBridgeQuad;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class TupleFinderOverDatasetGraph
implements TupleFinder4<Quad, Node> {
    protected DatasetGraph delegate;
    protected Predicate<Node> findInAnyNG;

    protected TupleFinderOverDatasetGraph(DatasetGraph delegate, Predicate<Node> findInAnyNG) {
        this.delegate = delegate;
        this.findInAnyNG = findInAnyNG;
    }

    public static TupleFinder4<Quad, Node> wrap(DatasetGraph dsg, Predicate<Node> useFindNG) {
        return new TupleFinderOverDatasetGraph(dsg, useFindNG);
    }

    public Stream<Quad> find(Node g, Node s, Node p, Node o) {
        boolean ng = this.findInAnyNG.test(g);
        Node gg = ng ? Node.ANY : g;
        Iterator it = ng ? this.delegate.findNG(gg, s, p, o) : this.delegate.find(g, s, p, o);
        return Iter.asStream((Iterator)it);
    }

    public TupleBridge4<Quad, Node> getTupleBridge() {
        return TupleBridgeQuad.get();
    }
}

