/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.tuple;

import com.google.common.base.Converter;
import java.util.function.Function;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;

public class ConverterTuple<ID, IC, OD, OC>
extends Converter<ID, OD> {
    protected TupleBridge<ID, IC> inBridge;
    protected TupleBridge<OD, OC> outBridge;
    protected TupleAccessor<ID, OC> toOutAccessor;
    protected TupleAccessor<OD, IC> toInAccessor;

    public ConverterTuple(TupleBridge<ID, IC> inBridge, TupleBridge<OD, OC> outBridge, TupleAccessor<ID, OC> toOutAccessor, TupleAccessor<OD, IC> toInAccessor) {
        this.inBridge = inBridge;
        this.outBridge = outBridge;
        this.toOutAccessor = toOutAccessor;
        this.toInAccessor = toInAccessor;
    }

    protected OD doForward(ID a) {
        Object result = this.outBridge.build(a, this.toOutAccessor);
        return (OD)result;
    }

    protected ID doBackward(OD b) {
        Object result = this.inBridge.build(b, this.toInAccessor);
        return (ID)result;
    }

    public static <ID, IC, OD, OC> Converter<ID, OD> create(TupleBridge<ID, IC> inBridge, TupleBridge<OD, OC> outBridge, Converter<IC, OC> componentConverter) {
        TupleAccessor toOutAccessor = inBridge.map(arg_0 -> componentConverter.convert(arg_0));
        TupleAccessor toInAccessor = outBridge.map(arg_0 -> ((Converter)componentConverter.reverse()).convert(arg_0));
        return new ConverterTuple<ID, IC, OD, OC>(inBridge, outBridge, toOutAccessor, toInAccessor);
    }

    public static <ID, IC, OD, OC> OD convert(ID inTuple, TupleAccessor<ID, IC> inAccessor, Function<IC, OC> inToOut, TupleBridge<OD, OC> outBridge) {
        TupleAccessor toOutAccessor = inAccessor.map(inToOut);
        Object result = outBridge.build(inTuple, toOutAccessor);
        return (OD)result;
    }
}

