/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.prologue;

import java.lang.reflect.Field;
import org.aksw.jenax.arq.util.irixresolver.IRIxResolverUtils;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;

public class PrologueUtils {
    public static Prologue newPrologueAsGiven() {
        return PrologueUtils.newPrologueAsGiven((PrefixMapping)new PrefixMappingImpl());
    }

    public static Prologue newPrologueAsGiven(PrefixMapping prefixMapping) {
        return new Prologue(prefixMapping, IRIxResolverUtils.newIRIxResolverAsGiven());
    }

    public static Prologue configure(Prologue target, Prologue source, String baseURI) {
        PrologueUtils.copy(target, source);
        PrologueUtils.setBaseURI(target, baseURI);
        return target;
    }

    public static Prologue setBaseURI(Prologue target, String baseURI) {
        if (baseURI != null) {
            IRIxResolver resolver = target.getResolver();
            if (resolver != null) {
                target.setBase(resolver.resolve(baseURI));
            } else {
                target.setBaseURI(baseURI);
            }
        }
        return target;
    }

    public static Prologue copy(Prologue target, Prologue source) {
        PrologueUtils.copyResolver(target, source);
        target.getPrefixMapping().setNsPrefixes(source.getPrefixMapping());
        return target;
    }

    public static Prologue copyResolver(Prologue target, Prologue source) {
        if (source.explicitlySetBaseURI()) {
            target.setBaseURI(source.getBaseURI());
            target.setBase(source.getBase());
        } else {
            PrologueUtils.setResolver(target, source.getResolver());
        }
        return target;
    }

    public static Prologue setResolver(Prologue prologue, IRIxResolver resolver) {
        try {
            Field field = Prologue.class.getDeclaredField("resolver");
            field.setAccessible(true);
            field.set(prologue, resolver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return prologue;
    }
}

