/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Rename;

public class VarScopeUtils {
    public static String getPlainName(String varName) {
        int delta = "/".length();
        int pos = 0;
        while (varName.startsWith("/", pos)) {
            pos += delta;
        }
        String result = varName.substring(pos);
        return result;
    }

    public static int getScopeLevel(Var var) {
        return VarScopeUtils.getScopeLevel(var.getName());
    }

    public static int getScopeLevel(String varName) {
        int result = 0;
        int delta = "/".length();
        int pos = 0;
        while (varName.startsWith("/", pos)) {
            pos += delta;
            ++result;
        }
        return result;
    }

    public static Var allocScoped(String baseName, int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("/");
        }
        sb.append(baseName);
        String varName = sb.toString();
        Var result = Var.alloc((String)varName);
        return result;
    }

    public static Map<String, Integer> getMinimumScopeLevels(Collection<Var> vars) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Var var : vars) {
            String scopedName = var.getName();
            String plainName = VarScopeUtils.getPlainName(scopedName);
            Integer priorLevel = (Integer)result.get(plainName);
            int thisLevel = VarScopeUtils.getScopeLevel(scopedName);
            if (priorLevel != null && thisLevel >= priorLevel) continue;
            result.put(plainName, thisLevel);
        }
        return result;
    }

    public static BiMap<Var, Var> normalizeVarScopes(Collection<Var> vars) {
        Map<String, Integer> nameToMinLevel = VarScopeUtils.getMinimumScopeLevels(vars);
        HashBiMap result = HashBiMap.create();
        for (Var from : vars) {
            String fromName = from.getName();
            int fromLevel = VarScopeUtils.getScopeLevel(fromName);
            String plainName = VarScopeUtils.getPlainName(fromName);
            int minLevel = nameToMinLevel.get(plainName);
            int normalizedLevel = fromLevel - minLevel;
            Var to = VarScopeUtils.allocScoped(plainName, normalizedLevel);
            result.put((Object)from, (Object)to);
        }
        return result;
    }

    public static BiMap<Var, Var> normalizeVarScopesGlobal(Collection<Var> vars) {
        int globalMinScopeLevel = vars.stream().mapToInt(VarScopeUtils::getScopeLevel).min().orElse(0);
        HashBiMap result = HashBiMap.create();
        for (Var from : vars) {
            String fromName = from.getName();
            int fromLevel = VarScopeUtils.getScopeLevel(fromName);
            String plainName = VarScopeUtils.getPlainName(fromName);
            int normalizedLevel = fromLevel - globalMinScopeLevel;
            Var to = VarScopeUtils.allocScoped(plainName, normalizedLevel);
            result.put((Object)from, (Object)to);
        }
        return result;
    }

    public static Map<Var, Var> reverseVarRenameMap(Collection<Var> vars) {
        Map result = vars.stream().collect(Collectors.toMap(v -> v, v -> (Var)Rename.reverseVarRename((Node)v), (v, w) -> v, LinkedHashMap::new));
        return result;
    }

    public static Set<Var> reverseVarRename(Collection<Var> vars) {
        return VarScopeUtils.reverseVarRename(vars, new LinkedHashSet());
    }

    public static <C extends Collection<? super Var>> C reverseVarRename(Collection<Var> vars, C acc) {
        for (Var v : vars) {
            Var w = (Var)Rename.reverseVarRename((Node)v);
            acc.add((Var)w);
        }
        return acc;
    }
}

