/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathCompiler;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class PathUtils {
    public static final Path typeSubclassOf = PathFactory.pathSeq((Path)PathFactory.pathLink((Node)RDF.type.asNode()), (Path)PathFactory.pathZeroOrMore1((Path)PathFactory.pathLink((Node)RDFS.subClassOf.asNode())));

    public static P_Path0 createStep(String predicate, boolean isFwd) {
        return PathUtils.createStep(NodeFactory.createURI((String)predicate), isFwd);
    }

    public static P_Path0 createStep(Node predicate, boolean isFwd) {
        P_Link result = isFwd ? new P_Link(predicate) : new P_ReverseLink(predicate);
        return result;
    }

    public static Path create(Path path, boolean isFwd) {
        Path result = isFwd ? path : PathFactory.pathInverse((Path)path);
        return result;
    }

    public static P_Path0 asStep(Path path) {
        return path instanceof P_Path0 ? (P_Path0)path : null;
    }

    public static BasicPattern flattenOrNull(TriplePath triplePath) {
        PathCompiler pathCompiler = new PathCompiler();
        PathBlock pathBlock = pathCompiler.reduce(triplePath);
        BasicPattern result = PathUtils.canFlatten(pathBlock) ? PathUtils.flatten(pathBlock) : null;
        return result;
    }

    public static boolean canFlatten(PathBlock pathBlock) {
        boolean result = pathBlock.getList().stream().allMatch(triplePath -> triplePath.getPath() instanceof P_Path0);
        return result;
    }

    public static BasicPattern flatten(PathBlock pathBlock) {
        BasicPattern bgp = new BasicPattern();
        for (TriplePath tp : pathBlock) {
            Path path = tp.getPath();
            if (path instanceof P_Path0) {
                P_Path0 p0 = (P_Path0)path;
                Triple t = TripleUtils.create(tp.getSubject(), p0.getNode(), tp.getObject(), p0.isForward());
                bgp.add(t);
                continue;
            }
            throw new RuntimeException("Could not flatten path: " + String.valueOf(path));
        }
        return bgp;
    }
}

