/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class NodeEnvsubst {
    public static final String ENV_PREFIX = "env:";

    public static Node subst(Node node, Function<String, String> lookup) {
        Map.Entry<String, Boolean> e = NodeEnvsubst.getEnvKey(node);
        Node result = node;
        if (e != null) {
            String key = e.getKey();
            boolean isUri = e.getValue();
            String value = lookup.apply(key);
            if (value != null) {
                result = isUri ? NodeFactory.createURI((String)value) : NodeFactory.createLiteral((String)value);
            }
        }
        return result;
    }

    public static Node substWithNode(Node node, Function<String, Node> lookup) {
        Map.Entry<String, Boolean> e = NodeEnvsubst.getEnvKey(node);
        Node result = node;
        if (e != null) {
            String key = e.getKey();
            boolean isUri = e.getValue();
            Node value = lookup.apply(key);
            if (value != null) {
                result = isUri ? NodeFactory.createURI((String)NodeEnvsubst.nodeToString(value)) : value;
            }
        }
        return result;
    }

    public static String nodeToString(Node node) {
        String result = node.isURI() ? node.getURI() : (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString());
        return result;
    }

    public static Map.Entry<String, Boolean> getEnvKey(Node node) {
        String str;
        Map.Entry result = null;
        if (node.isURI() && (str = node.getURI()).startsWith(ENV_PREFIX)) {
            String key = str.substring(ENV_PREFIX.length());
            boolean isIri = false;
            if (key.startsWith("//")) {
                key = key.substring(2);
                isIri = true;
            }
            result = Maps.immutableEntry((Object)key, (Object)isIri);
        }
        return result;
    }

    public static boolean isEnvKey(Node node) {
        boolean result = NodeEnvsubst.getEnvKey(node) != null;
        return result;
    }
}

