/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.util.obj.ObjectUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.graph.Node_Ext;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;

public class NodeCustom<T>
extends Node_Ext<T> {
    protected NodeCustom(T value) {
        super(value);
    }

    public Object visitWith(NodeVisitor v) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public T getValue() {
        return (T)this.get();
    }

    public Expr asExpr() {
        return ExprLib.nodeToExpr((Node)this);
    }

    public String toString(PrefixMapping pmap) {
        return this.toString();
    }

    public String toString() {
        return "NodeCustom [value=" + String.valueOf(this.get()) + "]";
    }

    @Deprecated
    public static NodeCustom<?> create(Object value) {
        return new NodeCustom<Object>(value);
    }

    public static <T> NodeCustom<T> of(T value) {
        return new NodeCustom<T>(value);
    }

    public static <T> T extract(Node node, Class<?> payloadClass) {
        T v;
        T result = null;
        if (node instanceof NodeCustom && payloadClass.isInstance(v = ((NodeCustom)node).getValue())) {
            result = v;
        }
        return result;
    }

    public static Stream<NodeCustom<?>> streamCustomNodes(Expr expr) {
        Stream<NodeCustom<?>> result = ExprUtils.nodesMentioned(expr).stream().flatMap(x -> ObjectUtils.tryCastAs(NodeCustom.class, (Object)x).stream()).map(x -> x);
        return result;
    }

    public static Stream<?> streamMentionedValues(Expr expr) {
        Stream<Object> result = NodeCustom.streamCustomNodes(expr).map(NodeCustom::getValue);
        return result;
    }

    public static <T> Set<T> mentionedValues(Class<?> payloadClass, Expr expr) {
        Set result = NodeCustom.streamMentionedValues(expr).flatMap(v -> ObjectUtils.tryCastAs((Class)payloadClass, (Object)v).stream()).map(x -> x).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public static <T> Expr resolveExpr(Expr expr, Class<?> payloadClass, Function<T, ? extends Node> mapping) {
        NodeTransform nodeTransform = NodeCustom.createNodeTransform(payloadClass, mapping);
        Expr result = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(nodeTransform), (Expr)expr);
        return result;
    }

    public static <T> NodeTransform createNodeTransform(Class<?> payloadClass, Function<? super T, ? extends Node> mapping) {
        return NodeTransformLib2.wrapWithNullAsIdentity(node -> {
            Object payload = ObjectUtils.tryCastAs(NodeCustom.class, (Object)node).flatMap(custom -> ObjectUtils.tryCastAs((Class)payloadClass, custom.getValue())).orElse(null);
            Node r = payload != null ? (Node)mapping.apply((Object)payload) : null;
            return r;
        });
    }

    public static <I, O> NodeTransform mapValue(Class<?> payloadClass, Function<? super I, O> mapping) {
        return NodeCustom.createNodeTransform(payloadClass, before -> {
            Object after = mapping.apply((Object)before);
            NodeCustom r = NodeCustom.of(after);
            return r;
        });
    }
}

