/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.jenax.arq.util.binding.MapFromBinding;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class BindingUtils {
    public static Node substitute(Node node, Binding binding) {
        Node result = node;
        if (node.isVariable() && (result = binding.get((Var)node)) == null) {
            throw new RuntimeException("Variable " + String.valueOf(node) + "not bound");
        }
        return result;
    }

    public static BindingBuilder add(BindingBuilder builder, List<Node> nodes, int i, Supplier<Node> valueSupplier) {
        int n;
        BindingBuilder result = builder;
        if (builder != null && i < (n = nodes.size())) {
            Node key = nodes.get(i);
            Node value = valueSupplier.get();
            if (value != null) {
                if (key.isVariable()) {
                    builder.add((Var)key, value);
                } else if (!Objects.equals(key, value)) {
                    result = null;
                }
            }
        }
        return result;
    }

    public static Node getValue(Binding binding, Node key) {
        Node result = key == null ? null : (key.isVariable() ? binding.get((Var)key) : key);
        return result;
    }

    public static Node getValue(Binding binding, Node key, Node defaultWhenNull) {
        Node result = BindingUtils.getValue(binding, key);
        if (result == null) {
            result = defaultWhenNull;
        }
        return result;
    }

    public static Binding project(Binding binding, Iterable<Var> vars) {
        return BindingUtils.project(binding, vars.iterator());
    }

    public static Binding project(Binding binding, Iterator<Var> vars) {
        BindingBuilder builder = BindingBuilder.create();
        while (vars.hasNext()) {
            Var var = vars.next();
            Node node = binding.get(var);
            if (node == null) continue;
            builder.add(var, node);
        }
        return builder.build();
    }

    public static Binding project(Binding binding, Iterator<Var> vars, Set<Var> blacklist) {
        BindingBuilder builder = BindingBuilder.create();
        while (vars.hasNext()) {
            Node node;
            Var var = vars.next();
            if (blacklist.contains(var) || (node = binding.get(var)) == null) continue;
            builder.add(var, node);
        }
        return builder.build();
    }

    public static Binding fromMap(Map<? extends Var, ? extends Node> map) {
        BindingBuilder builder = BindingBuilder.create();
        for (Map.Entry<? extends Var, ? extends Node> e : map.entrySet()) {
            builder.add(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    public static Binding transformKeys(Binding binding, NodeTransform transform) {
        Iterator it = binding.vars();
        BindingBuilder builder = BindingBuilder.create();
        while (it.hasNext()) {
            Var o = (Var)it.next();
            Node node = binding.get(o);
            Var n = (Var)transform.apply((Object)o);
            builder.add(n, node);
        }
        return builder.build();
    }

    public static Map<Var, Node> toMap(Binding binding) {
        HashMap<Var, Node> result = new HashMap<Var, Node>();
        Iterator it = binding.vars();
        while (it.hasNext()) {
            Var v = (Var)it.next();
            Node n = binding.get(v);
            result.put(v, n);
        }
        return result;
    }

    public static List<Binding> addRowIds(Collection<Binding> bindings, Var rowId) {
        ArrayList<Binding> result = new ArrayList<Binding>(bindings.size());
        long i = 0L;
        BindingBuilder builder = BindingBuilder.create();
        for (Binding parent : bindings) {
            builder.reset();
            builder.addAll(parent);
            Node node = NodeValue.makeInteger((long)i).asNode();
            builder.add(rowId, node);
            ++i;
            result.add(builder.build());
        }
        return result;
    }

    public static Binding renameKeys(Binding binding, Map<Var, Var> varMap) {
        return NodeTransformLib.transform((Binding)binding, (NodeTransform)NodeTransformRenameMap.create(varMap));
    }

    public static NodeTransform asNodeTransform(Binding binding) {
        return new NodeTransformSubst((Map)new MapFromBinding(binding));
    }

    public static Number getNumberNullable(Binding binding, Node key) {
        Node node = BindingUtils.getValue(binding, key);
        Number result = NodeUtils.getNumberNullable(node);
        return result;
    }

    public static Optional<Number> tryGetNumber(Binding binding, Node key) {
        return Optional.ofNullable(BindingUtils.getNumberNullable(binding, key));
    }

    public static Number getNumber(Binding binding, Node key) {
        Node node = BindingUtils.getValue(binding, key);
        Number result = NodeUtils.getNumber(node);
        return result;
    }

    public static void projectIntoArray(Node[] dest, int offset, Binding binding, Var[] projectVars) {
        for (Var var : projectVars) {
            Node node;
            dest[offset + i] = node = binding.get(var);
        }
    }

    public static Tuple<Node> projectAsTuple(Binding binding, Var[] projectVars) {
        Object[] tmp = new Node[projectVars.length];
        BindingUtils.projectIntoArray((Node[])tmp, 0, binding, projectVars);
        Tuple result = TupleFactory.create((Object[])tmp);
        return result;
    }

    public static List<Node> projectAsList(Binding binding, Var[] projectVars) {
        Node[] tmp = new Node[projectVars.length];
        BindingUtils.projectIntoArray(tmp, 0, binding, projectVars);
        List<Node> result = Arrays.asList(tmp);
        return result;
    }
}

