/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.jena.sparql.core.Var;

public class VarPartition {
    protected List<Var> partitionVars;
    protected VarPartition subPartition;

    protected VarPartition(List<Var> partitionVars, VarPartition subPartition) {
        this.partitionVars = partitionVars;
        this.subPartition = subPartition;
    }

    public static VarPartition of(List<Var> partitionVars) {
        return VarPartition.of(partitionVars, null);
    }

    public static VarPartition of(List<Var> partitionVars, VarPartition subPartition) {
        return new VarPartition(new ArrayList<Var>(partitionVars), subPartition);
    }

    public List<Var> getPartitionVars() {
        return this.partitionVars;
    }

    public VarPartition getSubPartition() {
        return this.subPartition;
    }

    public int hashCode() {
        return Objects.hash(this.partitionVars, this.subPartition);
    }

    public String toString() {
        String varStr = this.partitionVars.stream().map(Object::toString).collect(Collectors.joining(", "));
        String result = this.subPartition == null ? "(" + varStr + ")" : "(" + varStr + "," + this.subPartition.toString() + ")";
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VarPartition other = (VarPartition)obj;
        return Objects.equals(this.partitionVars, other.partitionVars) && Objects.equals(this.subPartition, other.subPartition);
    }
}

