/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.query;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.op.OpTransform;
import org.aksw.jenax.arq.util.query.OpTransformBuilder;
import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.arq.util.query.QueryTransformFromOpTransform;
import org.aksw.jenax.arq.util.query.QueryTransformList;
import org.aksw.jenax.arq.util.query.TransformList;
import org.apache.jena.sparql.expr.ExprTransform;

public class QueryTransformBuilder {
    protected List<QueryTransform> queryTransforms = new ArrayList<QueryTransform>();
    protected OpTransformBuilder opTransformBuilder = new OpTransformBuilder();

    protected void finalizeSubBuilder() {
        OpTransform opTransform = this.opTransformBuilder.build();
        if (opTransform != null) {
            this.queryTransforms.add(new QueryTransformFromOpTransform(opTransform));
            this.opTransformBuilder.reset();
        }
    }

    protected void addInternal(QueryTransform transform) {
        if (transform instanceof QueryTransformFromOpTransform) {
            QueryTransformFromOpTransform t = (QueryTransformFromOpTransform)transform;
            OpTransform rewrite = t.getOpTransform();
            this.opTransformBuilder.add(rewrite);
        } else {
            this.finalizeSubBuilder();
            this.queryTransforms.add(transform);
        }
    }

    public QueryTransformBuilder add(QueryTransform transform) {
        TransformList.streamFlatten(true, transform).forEach(this::addInternal);
        return this;
    }

    public QueryTransformBuilder add(OpTransform transform) {
        this.opTransformBuilder.add(transform);
        return this;
    }

    public QueryTransformBuilder add(ExprTransform transform) {
        this.opTransformBuilder.add(transform);
        return this;
    }

    public QueryTransform build() {
        Stream<Object> stream = this.queryTransforms.stream();
        OpTransform opTransform = this.opTransformBuilder.build();
        if (opTransform != null) {
            stream = Stream.concat(stream, Stream.of(new QueryTransformFromOpTransform(opTransform)));
        }
        return TransformList.flattenOrNull(true, QueryTransformList::new, stream);
    }

    public void reset() {
        this.queryTransforms.clear();
        this.opTransformBuilder.reset();
    }

    public String toString() {
        return "QueryTransformBuilder [queryTransforms=" + String.valueOf(this.queryTransforms) + ", opTransformBuilder=" + String.valueOf(this.opTransformBuilder) + "]";
    }
}

