/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.fmt;

import org.aksw.jenax.arq.util.fmt.SparqlQueryFmts;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;

public class SparqlQueryFmtsUtils {
    public static Lang getLang(SparqlQueryFmts fmts, Query query) {
        return switch (query.queryType()) {
            case QueryType.ASK -> fmts.forAskResult();
            case QueryType.SELECT -> fmts.forResultSet();
            case QueryType.CONSTRUCT -> query.isConstructQuad() ? fmts.forConstructQuad().getLang() : fmts.forConstruct().getLang();
            case QueryType.DESCRIBE -> fmts.forDescribe().getLang();
            default -> fmts.forUnknown();
        };
    }

    public static RDFFormat getRdfFormat(SparqlQueryFmts fmts, Query query) {
        return switch (query.queryType()) {
            case QueryType.ASK -> null;
            case QueryType.SELECT -> null;
            case QueryType.CONSTRUCT -> query.isConstructQuad() ? fmts.forConstructQuad() : fmts.forConstruct();
            case QueryType.DESCRIBE -> fmts.forDescribe();
            default -> null;
        };
    }
}

