/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.util.traversal;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.util.traverse.BreadthFirstSearchLib;
import org.aksw.jenax.util.traversal.GraphSuccessorFunction;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class NaiveLCAFinder {
    protected Graph graph;
    protected GraphSuccessorFunction successorFn;

    public NaiveLCAFinder(Graph graph) {
        this(graph, GraphSuccessorFunction.create(RDFS.Nodes.subClassOf, true));
    }

    public NaiveLCAFinder(Graph graph, GraphSuccessorFunction successorFn) {
        this.graph = graph;
        this.successorFn = successorFn;
    }

    public Set<Node> getLCASet(Node a, Node b) {
        Set<Node> result = NaiveLCAFinder.computeLCA(a, b, node -> this.successorFn.apply(this.graph, (Node)node));
        return result;
    }

    public Node getLCA(Node a, Node b) {
        Set<Node> tmp = this.getLCASet(a, b);
        if (tmp.size() > 1) {
            throw new IllegalArgumentException("More than one lca found for arguments " + String.valueOf(a) + " and " + String.valueOf(b) + ": " + String.valueOf(tmp));
        }
        Node result = tmp.isEmpty() ? null : tmp.iterator().next();
        return result;
    }

    public static <T> Set<T> computeLCA(T a, T b, Function<? super T, ? extends Stream<? extends T>> getParents) {
        LinkedHashSet result = new LinkedHashSet();
        Set aParents = Collections.singleton(a);
        Set bParents = Collections.singleton(b);
        HashSet aAncestors = new HashSet(aParents);
        HashSet bAncestors = new HashSet(bParents);
        boolean foundLcas = false;
        while (!aParents.isEmpty() || !bParents.isEmpty()) {
            boolean bl = foundLcas = NaiveLCAFinder.calcOverlap(aParents.iterator(), aAncestors, bAncestors, result) > 0;
            if (foundLcas) break;
            boolean bl2 = foundLcas = NaiveLCAFinder.calcOverlap(bParents.iterator(), bAncestors, aAncestors, result) > 0;
            if (foundLcas) break;
            aParents = aParents.stream().flatMap(getParents).filter(item -> !aAncestors.contains(item)).collect(Collectors.toCollection(LinkedHashSet::new));
            bParents = bParents.stream().flatMap(getParents).filter(item -> !bAncestors.contains(item)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return result;
    }

    public static <T> int calcOverlap(Iterator<? extends T> it, Collection<T> seen, Collection<? extends T> col, Collection<T> out) {
        int result = 0;
        while (it.hasNext()) {
            T pa = it.next();
            seen.add(pa);
            if (!col.contains(pa)) continue;
            out.add(pa);
            ++result;
        }
        return result;
    }

    public static void main(String[] args) {
        Model model = RDFDataMgr.loadModel((String)"xsd-ontology.ttl");
        Graph graph = model.getGraph();
        GraphSuccessorFunction gsf = GraphSuccessorFunction.create(RDFS.subClassOf.asNode(), true);
        NaiveLCAFinder alg = new NaiveLCAFinder(graph, gsf);
        Set<Node> actual = alg.getLCASet(XSD.nonNegativeInteger.asNode(), XSD.decimal.asNode());
        Set<Node> expected = Collections.singleton(XSD.decimal.asNode());
        TypeMapper tm = TypeMapper.getInstance();
        Stream breadthOfParentsStream = BreadthFirstSearchLib.stream(expected, node -> gsf.apply(graph, (Node)node), Collectors::toSet);
        Map javaTypeMap = breadthOfParentsStream.map(set -> {
            Map<Node, RDFDatatype> map = set.stream().map(node -> Maps.immutableEntry((Object)node, (Object)tm.getTypeByName(node.getURI()))).filter(e -> e.getValue() != null && ((RDFDatatype)e.getValue()).getJavaClass() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return map;
        }).filter(map -> !map.isEmpty()).findFirst().orElse(null);
        System.out.println(javaTypeMap);
        System.out.println(actual);
    }
}

