/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.triple;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Function;
import org.aksw.jenax.arq.util.triple.GraphNodeRemapBase;
import org.aksw.jenax.arq.util.triple.GraphVar;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.GraphFactory;

public class GraphVarImpl
extends GraphNodeRemapBase
implements GraphVar {
    protected BiMap<Var, Node> varToNode = HashBiMap.create();
    protected Function<Var, Node> nodeGenerator = v -> NodeFactory.createURI((String)("var://" + v.getName()));

    public GraphVarImpl() {
        this(GraphFactory.createDefaultGraph());
    }

    @Override
    public BiMap<Var, Node> getVarToNode() {
        return this.varToNode;
    }

    public GraphVarImpl(Graph base) {
        super(base);
        this.toGraph = n -> n.isVariable() ? (Node)this.varToNode.computeIfAbsent((Object)((Var)n), v -> this.nodeGenerator.apply((Var)v)) : n;
        this.fromGraph = n -> {
            Var v = (Var)this.varToNode.inverse().get(n);
            Node r = v == null ? n : v;
            return r;
        };
    }
}

