/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryType;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.AggCountDistinct;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;

public class QueryGenerationUtils {
    public static Query virtuosoFixForOrderedSlicing(Query query) {
        Query result;
        long o = query.getOffset();
        long l = query.getLimit();
        boolean hasLimitOrOffset = o != Long.MIN_VALUE || l != Long.MIN_VALUE;
        boolean hasOrderBy = query.hasOrderBy();
        if (query.isConstructType() || hasLimitOrOffset && hasOrderBy) {
            Query clone = query.cloneQuery();
            clone.setQuerySelectType();
            clone.setOffset(Long.MIN_VALUE);
            clone.setLimit(Long.MIN_VALUE);
            result = new Query();
            result.setQuerySelectType();
            result = QueryUtils.restoreQueryForm(result, query);
            result.setQueryPattern((Element)new ElementSubQuery(clone));
            clone.getPrefixMapping().clearNsPrefixMap();
            result.setOffset(o);
            result.setLimit(l);
        } else {
            result = query;
        }
        return result;
    }

    public static Query createQueryQuad(Quad quad) {
        Query query = new Query();
        query.setQuerySelectType();
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        s = g == null || g.equals((Object)Node.ANY) ? Vars.g : g;
        s = s == null || s.equals((Object)Node.ANY) ? Vars.s : s;
        p = p == null || p.equals((Object)Node.ANY) ? Vars.p : p;
        o = o == null || o.equals((Object)Node.ANY) ? Vars.o : o;
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        ElementTriplesBlock element = new ElementTriplesBlock(bgp);
        element = new ElementNamedGraph(g, (Element)element);
        query.setQueryPattern((Element)element);
        return query;
    }

    public static Query createQueryTriple(Triple m) {
        Query query = new Query();
        query.setQueryConstructType();
        Node s = m.getSubject();
        Node p = m.getPredicate();
        Node o = m.getObject();
        s = s == null || s.equals((Object)Node.ANY) ? Vars.s : s;
        p = p == null || p.equals((Object)Node.ANY) ? Vars.p : p;
        o = o == null || o.equals((Object)Node.ANY) ? Vars.o : o;
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        Template template = new Template(bgp);
        ElementTriplesBlock element = new ElementTriplesBlock(bgp);
        query.setConstructTemplate(template);
        query.setQueryPattern((Element)element);
        return query;
    }

    public static Query wrapAsSubQuery(Query query, Var v) {
        ElementSubQuery esq = new ElementSubQuery(query);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(v);
        result.setQueryPattern((Element)esq);
        return result;
    }

    public static Query wrapAsSubQuery(Query query) {
        ElementSubQuery esq = new ElementSubQuery(query);
        Query result = new Query();
        result.setQuerySelectType();
        result.setQueryResultStar(true);
        result.setQueryPattern((Element)esq);
        return result;
    }

    public static Map.Entry<Var, Query> createQueryCount(Query query) {
        return QueryGenerationUtils.createQueryCount(query, null, null);
    }

    public static Map.Entry<Var, Query> createQueryCountPartition(Query query, Collection<Var> partitionVars, Long itemLimit, Long rowLimit) {
        if (partitionVars != null && partitionVars.isEmpty()) {
            throw new IllegalArgumentException("Empty collection of variables for which to count bindings not permitted.");
        }
        Query clone = query.cloneQuery();
        if (clone.isConstructType()) {
            Template template = clone.getConstructTemplate();
            Set<Var> vars = partitionVars == null ? QuadPatternUtils.getVarsMentioned(template.getQuads()) : new LinkedHashSet<Var>(partitionVars);
            clone.setQuerySelectType();
            if (vars.isEmpty()) {
                throw new RuntimeException("Variables required for counting");
            }
            clone.setQueryResultStar(false);
            clone.addProjectVars(vars);
            clone.setDistinct(true);
        } else {
            LinkedHashSet<Var> allowedVars = partitionVars == null ? new LinkedHashSet<Var>(clone.getProjectVars()) : new LinkedHashSet<Var>(partitionVars);
            QueryGenerationUtils.removeNonProjectedVars(clone, allowedVars);
        }
        Map.Entry<Var, Query> result = QueryGenerationUtils.createQueryCountCore(clone, itemLimit, rowLimit);
        return result;
    }

    public static Map.Entry<Var, Query> createQueryCount(Query query, Long itemLimit, Long rowLimit) {
        Map.Entry<Var, Query> result = QueryGenerationUtils.createQueryCountPartition(query, null, itemLimit, rowLimit);
        return result;
    }

    public static boolean everyNeedleIsInAnyHaystack(Collection<? extends Collection<?>> haystacks, Collection<?> needles) {
        boolean result = needles.stream().allMatch(needle -> QueryGenerationUtils.anyHaystackHasTheNeedle(haystacks, needle));
        return result;
    }

    public static boolean anyHaystackHasTheNeedle(Collection<? extends Collection<?>> haystacks, Object needle) {
        boolean result = haystacks.stream().anyMatch(haystack -> haystack.contains(needle));
        return result;
    }

    public static boolean everyHaystackHasAnyNeedle(Collection<? extends Collection<?>> haystacks, Collection<?> needles) {
        boolean result = haystacks.stream().allMatch(haystack -> QueryGenerationUtils.haystackHasAnyNeedle(haystack, needles));
        return result;
    }

    public static boolean haystackHasAnyNeedle(Collection<?> haystack, Collection<?> needles) {
        boolean result = needles.stream().anyMatch(needle -> haystack.contains(needle));
        return result;
    }

    public static Query distinct(Query query) {
        Query clone = query.cloneQuery();
        if (!clone.isSelectType()) {
            throw new IllegalArgumentException("Query form must be of select type");
        }
        QueryGenerationUtils.optimizeGroupByToDistinct(clone);
        Set projVars = SetUtils.asSet((Iterable)clone.getProjectVars());
        Set<Set<Var>> distinctVarSets = QueryGenerationUtils.analyzeDistinctVarSets(clone);
        if (query.hasGroupBy()) {
            boolean areAllDistinctVarsRequested;
            boolean bl = areAllDistinctVarsRequested = !distinctVarSets.isEmpty() && QueryGenerationUtils.everyHaystackHasAnyNeedle(distinctVarSets, projVars);
            if (!areAllDistinctVarsRequested) {
                Query tmp = QueryGenerationUtils.wrapAsSubQuery(clone);
                tmp.setQueryResultStar(false);
                tmp.addProjectVars((Collection)projVars);
                tmp.setDistinct(true);
                clone = tmp;
            }
        } else {
            clone.setDistinct(true);
        }
        return clone;
    }

    public static Query project(Query query, Collection<Var> resultVars) {
        if (!query.isSelectType()) {
            throw new IllegalArgumentException("Query form must be of select type");
        }
        Query clone = query.cloneQuery();
        HashSet projVars = new HashSet(query.getProjectVars());
        Sets.SetView violations = Sets.difference((Set)SetUtils.asSet(resultVars), projVars);
        if (!violations.isEmpty()) {
            throw new RuntimeException("Cannot project variables that are not mentioned in the query; violations: " + String.valueOf(violations));
        }
        QueryGenerationUtils.removeNonProjectedVars(clone, resultVars);
        QueryGenerationUtils.optimizeGroupByToDistinct(clone);
        return clone;
    }

    public static Query project(Query query, boolean distinct, Collection<Var> vars) {
        Query proj = QueryGenerationUtils.project(query, vars);
        Query dist = QueryGenerationUtils.distinct(proj);
        return dist;
    }

    public static void removeNonProjectedVars(Query query, Collection<Var> allowedVars) {
        VarExprList proj = query.getProject();
        HashSet projVars = new HashSet(proj.getVars());
        allowedVars = SetUtils.asSet(allowedVars);
        for (Var v : projVars) {
            if (allowedVars.contains(v)) continue;
            proj.remove(v);
        }
    }

    public static Set<Set<Var>> analyzeDistinctVarSets(Query query) {
        LinkedHashSet<Set<Var>> result;
        block4: {
            SetMultimap<Expr, Var> exprToProjVars;
            block3: {
                result = new LinkedHashSet<Set<Var>>();
                VarExprList vel = query.getProject();
                exprToProjVars = VarExprListUtils.invert(vel);
                Set projExprs = exprToProjVars.keySet();
                if (!query.hasGroupBy()) break block3;
                VarExprList groupBy = query.getGroupBy();
                SetMultimap<Expr, Var> exprToGroupVars = VarExprListUtils.invert(groupBy);
                Set groupByExprs = exprToGroupVars.keySet();
                Sets.SetView diff = Sets.difference((Set)groupByExprs, (Set)projExprs);
                if (!diff.isEmpty()) break block4;
                for (Expr groupByExpr : groupByExprs) {
                    Set projVars = exprToProjVars.get((Object)groupByExpr);
                    result.add(projVars);
                }
                break block4;
            }
            if (query.isDistinct()) {
                for (Collection e : exprToProjVars.asMap().values()) {
                    Set projVars = (Set)e;
                    result.add(projVars);
                }
            }
        }
        return result;
    }

    public static boolean optimizeGroupByToDistinct(Query query) {
        return QueryGenerationUtils.optimizeGroupByToDistinct(query, false);
    }

    public static boolean discard(Query query) {
        return QueryGenerationUtils.optimizeGroupByToDistinct(query, false);
    }

    public static boolean optimizeGroupByToDistinct(Query query, boolean discardAggregators) {
        boolean modified = false;
        if (query.hasGroupBy() && !query.hasHaving()) {
            boolean areAllDistinctVarsRequested;
            Set<Set<Var>> distinctVarSets = QueryGenerationUtils.analyzeDistinctVarSets(query);
            if (discardAggregators) {
                Set groupByExprs = VarExprListUtils.invert(query.getGroupBy()).keySet();
                VarExprList proj = query.getProject();
                HashSet<Var> projGroupKeyVars = new HashSet<Var>();
                HashSet<Var> removals = new HashSet<Var>();
                for (Var projVar : new ArrayList(query.getProjectVars())) {
                    Expr projExpr = (Expr)proj.getExprs().getOrDefault(projVar, new ExprVar(projVar));
                    boolean isGroupKeyVar = groupByExprs.contains(projExpr);
                    if (isGroupKeyVar) {
                        projGroupKeyVars.add(projVar);
                        continue;
                    }
                    removals.add(projVar);
                }
                if (!projGroupKeyVars.isEmpty()) {
                    for (Var v : removals) {
                        proj.remove(v);
                    }
                }
            }
            Set projVars = SetUtils.asSet((Iterable)query.getProjectVars());
            boolean bl = areAllDistinctVarsRequested = !distinctVarSets.isEmpty() && QueryGenerationUtils.everyHaystackHasAnyNeedle(distinctVarSets, projVars);
            if (areAllDistinctVarsRequested) {
                boolean onlyGroupByVarsProjected = QueryGenerationUtils.everyNeedleIsInAnyHaystack(distinctVarSets, projVars);
                if (onlyGroupByVarsProjected) {
                    query.getGroupBy().clear();
                    query.getAggregators().clear();
                    query.setDistinct(true);
                    modified = true;
                } else if (query.isDistinct()) {
                    query.setDistinct(false);
                    modified = true;
                }
            }
        }
        return modified;
    }

    public static boolean isEffectiveQueryResultStar(Query query) {
        boolean result;
        if (query.isQueryResultStar()) {
            result = true;
        } else {
            HashSet projectVars = new HashSet(query.getProjectVars());
            Element elt = query.getQueryPattern();
            HashSet patternVars = elt == null ? Collections.emptySet() : new HashSet(PatternVars.vars((Element)query.getQueryPattern()));
            result = Sets.symmetricDifference(projectVars, (Set)patternVars).isEmpty();
        }
        return result;
    }

    public static Map.Entry<Var, Query> createQueryCountCore(Query rawQuery, Long itemLimit, Long rowLimit) {
        Var resultVar = QueryUtils.freshVar(rawQuery);
        Query query = QueryGenerationUtils.createQueryCountCore(resultVar, rawQuery, itemLimit, rowLimit);
        return Maps.immutableEntry((Object)resultVar, (Object)query);
    }

    public static boolean needsWrappingByFeatures(Query query) {
        return QueryGenerationUtils.needsWrappingByFeatures(query, true) || VarExprListUtils.hasExprs(query.getProject());
    }

    public static boolean needsWrappingByFeatures(Query query, boolean includeSlice) {
        boolean result;
        boolean bl = result = query.hasGroupBy() || query.hasAggregators() || query.hasHaving() || query.hasValues();
        if (includeSlice) {
            result = result || query.hasLimit() || query.hasOffset();
        }
        return result;
    }

    public static Query createQueryCountCore(Var resultVar, Query rawQuery, Long itemLimit, Long rowLimit) {
        Element queryPattern;
        boolean useCountDistinct;
        Var v;
        Expr e;
        long effectiveLimit;
        boolean isSubQueryNeeded;
        Objects.requireNonNull(resultVar, "resultVar must not be null");
        Objects.requireNonNull(rawQuery, "query must not be null");
        Query query = rawQuery.cloneQuery();
        QueryGenerationUtils.optimizeGroupByToDistinct(query, true);
        boolean enableCountDistinct = false;
        boolean isDistinct = query.isDistinct();
        int projVarCount = query.getProjectVars().size();
        boolean isEffectiveQueryResultStar = QueryGenerationUtils.isEffectiveQueryResultStar(query);
        boolean isSubQueryNeededBecauseOfFeatures = QueryGenerationUtils.needsWrappingByFeatures(query, false);
        boolean canAvoidSubQuery = enableCountDistinct && projVarCount == 1 || isEffectiveQueryResultStar || !isDistinct;
        boolean bl = isSubQueryNeeded = isSubQueryNeededBecauseOfFeatures || !canAvoidSubQuery;
        if (rowLimit != null && isDistinct && !isSubQueryNeededBecauseOfFeatures) {
            Element elt = query.getQueryPattern();
            Query subQuery = new Query();
            subQuery.setQuerySelectType();
            subQuery.setQueryResultStar(true);
            subQuery.setQueryPattern(elt);
            subQuery.setLimit(rowLimit.longValue());
            query.setQueryPattern((Element)new ElementSubQuery(subQuery));
        }
        long tmpItemLimit = itemLimit == null ? Long.MIN_VALUE : itemLimit;
        long queryLimit = query.getLimit();
        long l = queryLimit == Long.MIN_VALUE ? tmpItemLimit : (effectiveLimit = tmpItemLimit == Long.MIN_VALUE ? queryLimit : Math.min(queryLimit, itemLimit));
        if (effectiveLimit != Long.MIN_VALUE) {
            query.setLimit(effectiveLimit);
            isSubQueryNeeded = true;
        }
        Var singleResultVar = null;
        VarExprList project = query.getProject();
        if (project.size() == 1 && ((e = project.getExpr(v = (Var)project.getVars().iterator().next())) == null || e.isVariable() && e.asVar().equals((Object)v))) {
            singleResultVar = v;
        }
        boolean canUseCountDistinct = !isSubQueryNeeded && isDistinct && (isEffectiveQueryResultStar || singleResultVar != null);
        boolean bl2 = useCountDistinct = enableCountDistinct && canUseCountDistinct;
        AggCountDistinct agg = useCountDistinct ? (singleResultVar == null ? new AggCountDistinct() : new AggCountVarDistinct((Expr)new ExprVar(singleResultVar))) : (!isSubQueryNeeded && isDistinct ? new AggCountDistinct() : new AggCount());
        Query result = new Query();
        result.setQuerySelectType();
        result.setPrefixMapping(query.getPrefixMapping());
        Expr aggCount = result.allocAggregate((Aggregator)agg);
        result.getProject().add(resultVar, aggCount);
        if (isSubQueryNeeded) {
            Query q = query.cloneQuery();
            q.setPrefixMapping((PrefixMapping)new PrefixMappingImpl());
            queryPattern = new ElementSubQuery(q);
        } else {
            queryPattern = query.getQueryPattern();
        }
        result.setQueryPattern(queryPattern);
        return result;
    }

    public static Query constructToLateral(Query query, Quad quadVars, QueryType outputQueryType, boolean distinct, boolean project) {
        Query result;
        Preconditions.checkArgument((boolean)query.isConstructType(), (Object)"Query must be of CONSTRUCT type");
        Preconditions.checkArgument((boolean)Arrays.asList(QueryType.CONSTRUCT, QueryType.SELECT).contains(outputQueryType), (Object)"Output query type must be CONSTRUCT OR SELECT");
        if (QueryType.SELECT.equals((Object)outputQueryType) || distinct) {
            project = true;
        }
        Query copy = query.cloneQuery();
        VarExprList commonExpressions = new VarExprList();
        Template template = query.getConstructTemplate();
        boolean includeGraph = true;
        ArrayList<Element> groups = new ArrayList<Element>();
        template.getQuads().stream().map(q -> ElementUtils.createElementGroup(QueryGenerationUtils.quadToBinds(quadVars, q, true))).forEach(groups::add);
        Element union = ElementUtils.unionIfNeeded(groups);
        List<Element> elts = ElementUtils.toElementList(copy.getQueryPattern());
        elts.add((Element)new ElementLateral(union));
        Element newElt = ElementUtils.groupIfNeeded(elts);
        if (project) {
            Query subQuery = new Query();
            subQuery.setQuerySelectType();
            subQuery.setDistinct(distinct);
            VarExprList proj = subQuery.getProject();
            if (includeGraph) {
                proj.add((Var)quadVars.getGraph());
            }
            proj.add((Var)quadVars.getSubject());
            proj.add((Var)quadVars.getPredicate());
            proj.add((Var)quadVars.getObject());
            subQuery.setQueryPattern(newElt);
            newElt = new ElementSubQuery(subQuery);
        }
        if (QueryType.CONSTRUCT.equals((Object)outputQueryType)) {
            copy.setQueryPattern(newElt);
            QuadAcc quadAcc = new QuadAcc();
            if (includeGraph) {
                quadAcc.addQuad(quadVars);
            } else {
                quadAcc.addTriple(quadVars.asTriple());
            }
            copy.setConstructTemplate(new Template(quadAcc));
            result = copy;
        } else {
            result = ((ElementSubQuery)newElt).getQuery();
        }
        return result;
    }

    public static List<ElementBind> quadToBinds(Quad quadVars, Quad quad, boolean isRealQuad) {
        ArrayList<ElementBind> result = new ArrayList<ElementBind>(4);
        result.add(new ElementBind((Var)quadVars.getGraph(), ExprLib.nodeToExpr((Node)quad.getGraph())));
        result.add(new ElementBind((Var)quadVars.getSubject(), ExprLib.nodeToExpr((Node)quad.getSubject())));
        result.add(new ElementBind((Var)quadVars.getPredicate(), ExprLib.nodeToExpr((Node)quad.getPredicate())));
        result.add(new ElementBind((Var)quadVars.getObject(), ExprLib.nodeToExpr((Node)quad.getObject())));
        return result;
    }

    public static Query discardUnbound(Query query) {
        Preconditions.checkArgument((boolean)query.isSelectType(), (Object)"SELECT query expected.");
        Query copy = query.cloneQuery();
        Query result = new Query();
        result.setQuerySelectType();
        result.setQueryResultStar(true);
        ExprList exprs = new ExprList(query.getProjectVars().stream().map(v -> new E_Bound((Expr)new ExprVar(v))).collect(Collectors.toList()));
        Element elt = ElementUtils.groupIfNeeded(new Element[]{new ElementSubQuery(copy), new ElementFilter(ExprUtils.orifyBalanced((Iterable<Expr>)exprs))});
        result.setQueryPattern(elt);
        return result;
    }
}

