/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.util.node;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.NodeCmp;

public class NodeUtils {
    public static final NodeFormatter ntFormatter = new NodeFormatterNT();
    public static final NodeFormatter ttlFormatter = new NodeFormatterTTL();
    public static final String nullUri = "http://null.null/null";
    public static final Node nullUriNode = NodeFactory.createURI((String)"http://null.null/null");
    public static final String ANY_IRI_STR = "urn:x-jenax:any";
    public static final Node ANY_IRI = NodeFactory.createURI((String)"urn:x-jenax:any");
    public static final String R2RML_NS = "http://www.w3.org/ns/r2rml#";
    public static final String R2RML_IRI = "http://www.w3.org/ns/r2rml#IRI";
    public static final String R2RML_BlankNode = "http://www.w3.org/ns/r2rml#BlankNode";

    public static int hashCode(Node node) {
        int result = node == null ? 0 : node.hashCode();
        return result;
    }

    public static int compareAlways(Node o1, Node o2) {
        int result;
        try {
            result = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : NodeValue.compareAlways((NodeValue)NodeValue.makeNode((Node)o1), (NodeValue)NodeValue.makeNode((Node)o2)));
        }
        catch (Exception e) {
            result = NodeCmp.compareRDFTerms((Node)o1, (Node)o2);
        }
        return result;
    }

    public static Set<Node> getBnodesMentioned(Iterable<Node> nodes) {
        Set<Node> result = Streams.stream(nodes).filter(Objects::nonNull).filter(Node::isBlank).collect(Collectors.toSet());
        return result;
    }

    public static Set<Var> getVarsMentioned(Iterable<Node> nodes) {
        Set<Var> result = Streams.stream(nodes).filter(Objects::nonNull).filter(Node::isVariable).map(node -> (Var)node).collect(Collectors.toSet());
        return result;
    }

    public static boolean isNullOrAny(Node node) {
        return node == null || Node.ANY.equals((Object)node);
    }

    @Deprecated
    public static Node nullToAny(Node n) {
        return org.apache.jena.sparql.util.NodeUtils.nullToAny((Node)n);
    }

    public static Node anyToNull(Node n) {
        return Node.ANY.equals((Object)n) ? null : n;
    }

    public static Node nullOrFluentToAny(Node n) {
        return n == null || !n.isConcrete() ? Node.ANY : n;
    }

    public static Node nullOrVarToAny(Node node) {
        if (node == null || node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public static Node logicalAnd(Node pattern, Node b) {
        Node result = NodeUtils.isNullOrAny(pattern) || pattern.isVariable() ? NodeUtils.nullToAny(b) : (NodeUtils.isNullOrAny(b) || Objects.equals(pattern, b) ? NodeUtils.nullToAny(pattern) : null);
        return result;
    }

    public static String getLang(Node node) {
        String result = node != null && node.isLiteral() ? node.getLiteralLanguage() : null;
        return result;
    }

    public static String getIriOrNull(Node node) {
        return node == null ? null : (node.isURI() ? node.getURI() : null);
    }

    public static String getDatatypeIri(Node node) {
        String result = node == null ? null : (node.isURI() ? R2RML_IRI : (node.isBlank() ? R2RML_BlankNode : (node.isLiteral() ? node.getLiteralDatatypeURI() : null)));
        return result;
    }

    public static Node createTypedLiteral(TypeMapper typeMapper, Object o) {
        Class<?> clazz = o.getClass();
        RDFDatatype dtype = typeMapper.getTypeByClass(clazz);
        String lex = dtype.unparse(o);
        Node result = NodeFactory.createLiteral((String)lex, (RDFDatatype)dtype);
        return result;
    }

    public static Node createUriOrNull(String uri) {
        Node result = uri == null ? null : NodeFactory.createURI((String)uri);
        return result;
    }

    public static List<Node> fromUris(Iterable<String> uris) {
        ArrayList<Node> result = new ArrayList<Node>(Iterables.size(uris));
        for (String uri : uris) {
            Node node = NodeFactory.createURI((String)uri);
            result.add(node);
        }
        return result;
    }

    public static List<Node> createLiteralNodes(Iterable<String> strings) {
        return Streams.stream(strings).map(NodeFactory::createLiteral).collect(Collectors.toList());
    }

    public static Number getNumberNullable(Node node) {
        Number result = null;
        if (node != null) {
            Object obj = node.getLiteralValue();
            if (!(obj instanceof Number)) {
                throw new RuntimeException("Value is not returned as a number");
            }
            result = (Number)obj;
        }
        return result;
    }

    public static Number getNumber(Node node) {
        Number number = NodeUtils.getNumberNullable(node);
        Objects.requireNonNull(number, "Number expected but got null");
        return number;
    }

    public static String strNodesWithUndef(BiConsumer<IndentedWriter, Node> output, Node ... nodes) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        boolean first = true;
        for (Node n : nodes) {
            if (!first) {
                sw.append(" ", new Object[0]);
            }
            first = false;
            if (n == null) {
                sw.append("UNDEF", new Object[0]);
                continue;
            }
            output.accept((IndentedWriter)sw, n);
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node parseNode(String str) {
        Node result = null;
        LabelToNode decoder = LabelToNode.createUseLabelEncoded();
        try (Tokenizer tokenizer = TokenizerText.create().fromString(str).build();){
            if (tokenizer.hasNext()) {
                Token token = tokenizer.next();
                Node node = token.asNode();
                if (node != null && node.isBlank()) {
                    String label = node.getBlankNodeLabel();
                    node = (Node)decoder.get(null, (Object)label);
                }
                result = node;
            }
            if (tokenizer.hasNext()) {
                throw new IllegalArgumentException("String parsed into more than 1 node.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C extends Collection<? super Node>> C parseNodes(String str, C segments) {
        LabelToNode decoder = LabelToNode.createUseLabelEncoded();
        try (Tokenizer tokenizer = TokenizerText.create().fromString(str).build();){
            while (tokenizer.hasNext()) {
                Token token = tokenizer.next();
                Node node = token.asNode();
                if (node != null && node.isBlank()) {
                    String label = node.getBlankNodeLabel();
                    node = (Node)decoder.get(null, (Object)label);
                }
                segments.add((Node)node);
            }
        }
        return segments;
    }

    public static Node createGraphNode(String graphName) {
        Node result = graphName == null || graphName.isBlank() || graphName.equalsIgnoreCase("default") ? Quad.defaultGraphIRI : NodeFactory.createURI((String)graphName);
        return result;
    }

    public static boolean isValid(Node node) {
        boolean result = false;
        try {
            NodeUtils.validate(node);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isValid(String str, Node node) {
        boolean result = false;
        try {
            NodeUtils.validate(str, node);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void validate(Node node) {
        String str = NodeFmtLib.strNT((Node)node);
        NodeUtils.validate(str, node);
    }

    public static void validate(String str, Node node) {
        List nodes;
        try {
            nodes = NodeUtils.parseNodes(str, new ArrayList());
        }
        catch (Exception e) {
            throw new ExprEvalException("Node " + String.valueOf(node) + " did not print-parse");
        }
        if (nodes.size() == 1) {
            Node actual = (Node)nodes.get(0);
            if (!node.equals((Object)actual)) {
                throw new ExprEvalException("Node " + String.valueOf(node) + " print-parsed into " + String.valueOf(actual));
            }
        } else {
            throw new ExprEvalException("Node " + String.valueOf(node) + " did not print-parse");
        }
    }

    public static boolean put(BindingBuilder builder, Node nodeOrVar, Node node) {
        boolean result = true;
        if (!NodeUtils.isNullOrAny(node)) {
            if (nodeOrVar.isVariable()) {
                builder.add((Var)nodeOrVar, node);
            } else if (!nodeOrVar.equals((Object)node)) {
                result = false;
            }
        }
        return result;
    }

    public static String getIriOrString(Node node) {
        String result;
        String string = node == null ? null : (node.isURI() ? node.getURI() : (result = node.isLiteral() && (org.apache.jena.sparql.util.NodeUtils.isSimpleString((Node)node) || org.apache.jena.sparql.util.NodeUtils.isLangString((Node)node)) ? node.getLiteralLexicalForm() : null));
        if (result == null) {
            NodeValue.raise((ExprException)new ExprTypeException("datatype: Neither IRI nor string: " + String.valueOf(node)));
        }
        return result;
    }

    public static String getUnquotedForm(Node node) {
        String result = node == null ? "" : (node.isLiteral() ? node.getLiteralLexicalForm() : (node.isURI() ? node.getURI() : (node.isBlank() ? node.getBlankNodeLabel() : (node.isVariable() ? node.getName() : NodeFmtLib.displayStr((Node)node)))));
        return result;
    }
}

